package cn.schoolwow.quickdao.flow.ddl.createTable;

import cn.schoolwow.quickdao.domain.external.Entity;
import cn.schoolwow.quickdao.domain.external.QuickDAOConfig;
import cn.schoolwow.quickdao.domain.internal.common.ResultSetConsumer;
import cn.schoolwow.quickdao.flow.ddl.createTable.common.ExecuteCreateTableFlow;
import cn.schoolwow.quickdao.flow.executor.ExecuteQueryConnectionFlow;
import cn.schoolwow.quickdao.flow.executor.ExecuteUpdateConnectionFlow;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;

import java.sql.ResultSet;

public class OracleCreateTableFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        flowContext.executeFlowList(
                new PostgresCreateTableFlow(),
                new ExecuteCreateTableFlow()
        );
        createSequence(flowContext);
    }

    @Override
    public String name() {
        return "Postgres数据库创建表";
    }

    /**创建序列和触发器*/
    private void createSequence(FlowContext flowContext) throws Exception {
        QuickDAOConfig quickDAOConfig = (QuickDAOConfig) flowContext.checkData("quickDAOConfig");
        Entity entity = (Entity) flowContext.checkData("entity");
        if(null==entity.id){
            return;
        }
        final StringBuilder createSequenceBuilder = new StringBuilder();
        //创建序列
        {
            flowContext.startFlow(new ExecuteQueryConnectionFlow())
                    .putTemporaryData("name", "判断序列是否存在")
                    .putTemporaryData("sql", "select sequence_name from user_sequences where sequence_name= '" + entity.tableName.toUpperCase() + "_SEQ'")
                    .putReturnData("resultSetConsumer",new ResultSetConsumer() {
                        @Override
                        public void consumeResultSet(ResultSet resultSet) throws Exception {
                            if(resultSet.next()){
                                //删除序列
                                createSequenceBuilder.append("drop sequence " + entity.tableName.toUpperCase() + "_SEQ;");
                            }
                        }
                    }).execute();

            //创建序列
            createSequenceBuilder.append("create sequence " + entity.tableName + "_seq increment by 1 start with 1 minvalue 1 maxvalue 9999999999999 nocache order;");
            flowContext.startFlow(new ExecuteUpdateConnectionFlow())
                    .putTemporaryData("name", "创建序列")
                    .putTemporaryData("sql", createSequenceBuilder.toString())
                    .execute();
        }
        //创建触发器
        {
            String createTrigger = "create or replace trigger " + entity.tableName + "_trigger " +
                    "before insert on " + quickDAOConfig.databaseContext.databaseProvider.escape(entity.tableName) + " " +
                    "for each row when(new.\"" + entity.id.column + "\" is null) " +
                    "begin select " + entity.tableName + "_seq.nextval into:new.\"" + entity.id.column + "\" from dual; end;";
            flowContext.startFlow(new ExecuteUpdateConnectionFlow())
                    .putTemporaryData("name", "创建触发器")
                    .putTemporaryData("sql", createTrigger)
                    .execute();
        }
    }

}
