package cn.schoolwow.quickdao.flow.ddl.common;

import cn.schoolwow.quickdao.domain.external.PropertyOption;
import cn.schoolwow.quickdao.domain.external.QuickDAOConfig;
import cn.schoolwow.quickdao.domain.internal.DatabaseType;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;

public class GetAutoIncrementStatementFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        QuickDAOConfig quickDAOConfig = (QuickDAOConfig) flowContext.checkData("quickDAOConfig");
        DatabaseType databaseType = (DatabaseType) flowContext.checkData("databaseType");
        PropertyOption propertyOption = (PropertyOption) flowContext.checkData("propertyOption");
        StringBuilder sqlBuilder = (StringBuilder) flowContext.checkData("sqlBuilder");

        switch (databaseType){
            case SQLite:{
                sqlBuilder.append(propertyOption.column + " " + propertyOption.columnType + (null == propertyOption.range ? "" : "(" + propertyOption.range + ")") + " primary key autoincrement");
            }break;
            case H2:
            case Mysql:
            case MariaDB:{
                sqlBuilder.append(propertyOption.column + " " + propertyOption.columnType + (null == propertyOption.range ? "" : "(" + propertyOption.range + ")") + " primary key auto_increment");
            }break;
            case Postgresql:
            case Oracle:{
                sqlBuilder.append(quickDAOConfig.databaseContext.databaseProvider.escape(propertyOption.column) + " BIGSERIAL UNIQUE PRIMARY KEY");
            }break;
            case SQLServer:{
                sqlBuilder.append(propertyOption.column + " " + propertyOption.columnType + (null == propertyOption.range ? "" : "(" + propertyOption.range + ")") + " identity(1,1) unique ");
            }break;
        }
    }

    @Override
    public String name() {
        return "获取自增id字段语句";
    }
}
