package cn.schoolwow.quickdao.flow.ddl.common;

import cn.schoolwow.quickdao.domain.external.QuickDAOConfig;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;

public class DeleteDatabaseEntityCacheFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        QuickDAOConfig quickDAOConfig = (QuickDAOConfig) flowContext.checkData("quickDAOConfig");
        String tableName = (String) flowContext.checkData("tableName");
        quickDAOConfig.deleteDatabaseEntityCache(tableName);
    }

    @Override
    public String name() {
        return "删除数据库表缓存信息";
    }
}
