package cn.schoolwow.quickdao.flow.dcl;

import cn.schoolwow.quickdao.domain.internal.DatabaseType;
import cn.schoolwow.quickdao.flow.executor.ExecuteUpdateConnectionFlow;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;

public class ModifyPasswordFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        DatabaseType databaseType = (DatabaseType) flowContext.checkData("databaseType");

        String username = (String) flowContext.checkData("username");
        String newPassword = (String) flowContext.checkData("newPassword");

        flowContext.putTemporaryData("name", "修改数据库用户密码");
        switch (databaseType){
            case Mysql:{
                flowContext.putTemporaryData("sql", "set password for " + username + " = password('" + newPassword + "');");
            };break;
            case Postgresql:{
                flowContext.putTemporaryData("sql", "alter user " + username + " with password '" + newPassword + "';");
            };break;
            default:{
                throw new UnsupportedOperationException("当前数据库不支持修改数据库用户密码!数据库类型:"+databaseType.name());
            }
        }
        flowContext.executeFlowList(new ExecuteUpdateConnectionFlow());
    }

    @Override
    public String name() {
        return "修改数据库用户密码";
    }
}
