package cn.schoolwow.quickdao.flow.dcl;

import cn.schoolwow.quickdao.domain.external.dcl.GrantOption;
import cn.schoolwow.quickdao.domain.internal.DatabaseType;
import cn.schoolwow.quickdao.flow.executor.ExecuteUpdateConnectionFlow;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;

public class GrantFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        DatabaseType databaseType = (DatabaseType) flowContext.checkData("databaseType");
        GrantOption grantOption = (GrantOption) flowContext.checkData("grantOption");

        flowContext.putTemporaryData("name", "数据库授权");
        switch (databaseType){
            case Mysql:{
                flowContext.putTemporaryData("sql", "grant " + grantOption.privileges + " on " + grantOption.databaseName + ".* to '" + grantOption.dataBaseUser.username + "'@'" + grantOption.dataBaseUser.host + "';");
            };break;
            case Postgresql:{
                flowContext.putTemporaryData("sql", "grant " + grantOption.privileges + " on database " + grantOption.databaseName + " to " + grantOption.dataBaseUser.username + ";");
            };break;
            default:{
                throw new UnsupportedOperationException("当前数据库不支持数据库授权操作!数据库类型:"+databaseType.name());
            }
        }
        flowContext.executeFlowList(new ExecuteUpdateConnectionFlow());
    }

    @Override
    public String name() {
        return "数据库授权";
    }
}
