package cn.schoolwow.quickdao.flow.dcl;

import cn.schoolwow.quickdao.domain.external.dcl.DataBaseUser;
import cn.schoolwow.quickdao.domain.internal.DatabaseType;
import cn.schoolwow.quickdao.flow.executor.ExecuteUpdateConnectionFlow;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;

public class CreateUserFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        DatabaseType databaseType = (DatabaseType) flowContext.checkData("databaseType");
        DataBaseUser dataBaseUser = (DataBaseUser) flowContext.checkData("dataBaseUser");

        flowContext.putTemporaryData("name", "创建数据库用户");
        switch (databaseType){
            case Mysql:{
                flowContext.putTemporaryData("sql", "create user '" + dataBaseUser.username + "'@'" + dataBaseUser.host + "' identified by '" + dataBaseUser.password + "';");
            };break;
            case Postgresql:{
                flowContext.putTemporaryData("sql", "create user " + dataBaseUser.username + " with password '" + dataBaseUser.password + "';");
            };break;
            default:{
                throw new UnsupportedOperationException("当前数据库不支持创建数据库用户!数据库类型:"+databaseType.name());
            }
        }
        flowContext.executeFlowList(new ExecuteUpdateConnectionFlow());
    }

    @Override
    public String name() {
        return "创建数据库用户";
    }
}
