package cn.schoolwow.quickdao.domain.internal.dql.subquery;

import cn.schoolwow.quickdao.dao.dql.condition.Condition;
import cn.schoolwow.quickdao.dao.dql.subCondition.SubCondition;
import cn.schoolwow.quickdao.domain.internal.dql.query.QueryOption;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * 查询列信息
 * */
public class SubQueryJoinTableOption implements Serializable {
    /**
     * 父表字段
     */
    public String primaryField;

    /**
     * 子表字段
     */
    public String joinTableField;

    /**
     * 对象变量名
     */
    public String compositeFieldName;

    /**
     * on条件映射列表
     */
    public List<SubQueryOnCondition> onConditionList = new ArrayList<>();

    /**
     * 连接方式
     */
    public String join = "join";

    /**
     * 关联父表
     * */
    public SubQueryOption parentSubQueryOption;

    /**
     * 父表对象
     * */
    public transient SubCondition parentCondition;

    /**
     * 关联主表
     * */
    public transient QueryOption queryOption;

    /**
     * 主表对象
     * */
    public transient Condition condition;
}
