package cn.schoolwow.quickdao.domain.internal.dml;

import cn.schoolwow.quickdao.domain.external.UpdateType;
import cn.schoolwow.quickdao.domain.external.dml.CheckStrategy;

import java.util.HashSet;
import java.util.Set;

/**
 * 操作语句选项
 */
public class ManipulationOption {
    /**
     * 是否返回自增id
     */
    public boolean returnGeneratedKeys = true;

    /**
     * 是否启用批处理
     */
    public boolean batch;

    /**
     * 每次最大更新个数(为空则取默认值)
     */
    public Integer perBatchCount;

    /**
     * 部分更新字段
     */
    public Set<String> partColumnSet = new HashSet<>();

    /**
     * 排除字段
     */
    public Set<String> excludeColumnSet = new HashSet<>();

    /**
     * 唯一字段
     */
    public Set<String> uniqueFieldNames = new HashSet<>();

    /**
     * 更新类型(默认自动选择)
     */
    public UpdateType updateType;

    /**
     * 字段约束检查策略
     */
    public CheckStrategy checkStrategy;

}
