package cn.schoolwow.quickdao.dao.dml;

import cn.schoolwow.quickdao.dao.sql.DatabaseDAOImpl;
import cn.schoolwow.quickdao.domain.external.Entity;
import cn.schoolwow.quickdao.domain.external.QuickDAOConfig;
import cn.schoolwow.quickdao.domain.external.UpdateType;
import cn.schoolwow.quickdao.domain.external.dml.CheckStrategy;
import cn.schoolwow.quickdao.domain.internal.dml.GetBatchParametersSupplier;
import cn.schoolwow.quickdao.domain.internal.dml.ManipulationOption;
import cn.schoolwow.quickdao.domain.internal.dql.common.SFunction;
import cn.schoolwow.quickdao.flow.dml.TruncateTableFlow;
import cn.schoolwow.quickdao.flow.dml.instance.common.SetInstanceEntityFlow;
import cn.schoolwow.quickdao.flow.dml.instance.common.filter.FilterInstanceByConstraintFlow;
import cn.schoolwow.quickdao.flow.dml.instance.common.filter.FilterInstanceBySameUniqueKeyFlow;
import cn.schoolwow.quickdao.flow.dml.instance.delete.DeleteInstanceArrayFlow;
import cn.schoolwow.quickdao.flow.dml.instance.delete.DeleteInstanceFlow;
import cn.schoolwow.quickdao.flow.dml.instance.insert.InsertIgnoreInstanceArrayFlow;
import cn.schoolwow.quickdao.flow.dml.instance.insert.InsertIgnoreInstanceFlow;
import cn.schoolwow.quickdao.flow.dml.instance.insert.InsertInstanceArrayFlow;
import cn.schoolwow.quickdao.flow.dml.instance.insert.InsertInstanceFlow;
import cn.schoolwow.quickdao.flow.dml.instance.save.SaveInstanceArrayFlow;
import cn.schoolwow.quickdao.flow.dml.instance.save.SaveInstanceFlow;
import cn.schoolwow.quickdao.flow.dml.instance.update.UpdateInstanceArrayFlow;
import cn.schoolwow.quickdao.flow.dml.instance.update.UpdateInstanceFlow;
import cn.schoolwow.quickdao.flow.dml.json.common.SetJSONObjectEntityFlow;
import cn.schoolwow.quickdao.flow.dml.json.common.filter.FilterJSONArrayByConstraintFlow;
import cn.schoolwow.quickdao.flow.dml.json.common.filter.FilterJSONArrayBySameUniqueFieldFlow;
import cn.schoolwow.quickdao.flow.dml.json.delete.DeleteJSONArrayFlow;
import cn.schoolwow.quickdao.flow.dml.json.delete.DeleteJSONObjectFlow;
import cn.schoolwow.quickdao.flow.dml.json.insert.InsertIgnoreJSONArrayFlow;
import cn.schoolwow.quickdao.flow.dml.json.insert.InsertIgnoreJSONObjectFlow;
import cn.schoolwow.quickdao.flow.dml.json.insert.InsertJSONArrayFlow;
import cn.schoolwow.quickdao.flow.dml.json.insert.InsertJSONObjectFlow;
import cn.schoolwow.quickdao.flow.dml.json.save.SaveJSONArrayFlow;
import cn.schoolwow.quickdao.flow.dml.json.save.SaveJSONObjectFlow;
import cn.schoolwow.quickdao.flow.dml.json.update.UpdateJSONArrayFlow;
import cn.schoolwow.quickdao.flow.dml.json.update.UpdateJSONObjectFlow;
import cn.schoolwow.quickdao.flow.executor.ExecuteBatchUpdateConnectionFlow;
import cn.schoolwow.quickdao.flow.executor.ExecuteUpdateConnectionFlow;
import cn.schoolwow.quickdao.util.LambdaUtils;
import cn.schoolwow.quickflow.QuickFlow;
import cn.schoolwow.quickflow.domain.FlowContext;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class DatabaseManipulationImpl extends DatabaseDAOImpl implements DatabaseManipulation {
    /**
     * 执行语句选项
     */
    private ManipulationOption manipulationOption = new ManipulationOption();

    public DatabaseManipulationImpl(QuickFlow quickFlow, QuickDAOConfig quickDAOConfig) {
        super(quickFlow, quickDAOConfig);
    }

    @Override
    public DatabaseManipulation returnGeneratedKeys(boolean returnGeneratedKeys) {
        manipulationOption.returnGeneratedKeys = returnGeneratedKeys;
        if(manipulationOption.returnGeneratedKeys){
            //开启了获取自增id就无法实现批处理
            manipulationOption.batch = false;
        }else{
            manipulationOption.batch = true;
        }
        return this;
    }

    @Override
    public DatabaseManipulation batch(boolean batch) {
        manipulationOption.batch = batch;
        if (manipulationOption.batch) {
            //开启了批处理就无法获取自增id
            manipulationOption.returnGeneratedKeys = false;
        }else{
            manipulationOption.returnGeneratedKeys = true;
        }
        return this;
    }

    @Override
    public DatabaseManipulation perBatchCount(int perBatchCount) {
        manipulationOption.perBatchCount = perBatchCount;
        return this;
    }

    @Override
    public DatabaseManipulation partColumn(String... fieldNames) {
        manipulationOption.partColumnSet.addAll(Arrays.asList(fieldNames));
        return this;
    }

    @Override
    public DatabaseManipulation excludeColumn(String... fieldNames) {
        manipulationOption.excludeColumnSet.addAll(Arrays.asList(fieldNames));
        return this;
    }

    @Override
    public DatabaseManipulation uniqueFieldNames(String... uniqueFieldNames) {
        manipulationOption.uniqueFieldNames.addAll(Arrays.asList(uniqueFieldNames));
        return this;
    }

    @Override
    public DatabaseManipulation updateType(UpdateType updateType) {
        manipulationOption.updateType = updateType;
        return this;
    }

    @Override
    public DatabaseManipulation checkStrategy(CheckStrategy checkStrategy) {
        manipulationOption.checkStrategy = checkStrategy;
        return this;
    }

    @Override
    public Map<JSONObject, String> getReasonInstanceMap(String tableName, JSONArray instances) {
        if(null==instances||instances.size()==0){
            return null;
        }
        manipulationOption.checkStrategy = CheckStrategy.CheckAndFilter;
        FlowContext flowContext = quickFlow.startFlow("获取不符合约束的JSONArray")
                .putTemporaryData("tableName", tableName)
                .putTemporaryData("instances", instances)
                .putTemporaryData("manipulationOption", manipulationOption)
                .next(new SetJSONObjectEntityFlow())
                .next(new FilterJSONArrayBySameUniqueFieldFlow())
                .next(new FilterJSONArrayByConstraintFlow())
                .execute();
        if(manipulationOption.uniqueFieldNames.isEmpty()){
            throw new IllegalArgumentException("先调用uniqueFieldNames方法指定唯一字段");
        }
        Map<JSONObject,String> instanceReasonMap = (Map<JSONObject,String>) flowContext.getData("instanceReasonMap");
        return instanceReasonMap;
    }

    @Override
    public int insert(String tableName, JSONObject instance) {
        if(null==instance){
            return 0;
        }
        FlowContext flowContext = quickFlow.startFlow(new InsertJSONObjectFlow())
                .putTemporaryData("tableName", tableName)
                .putTemporaryData("instance", instance)
                .putTemporaryData("manipulationOption", manipulationOption)
                .execute();
        return getEffect(flowContext);
    }

    @Override
    public int insert(String tableName, JSONArray instances) {
        if(null==instances||instances.isEmpty()){
            return 0;
        }
        FlowContext flowContext = quickFlow.startFlow(new InsertJSONArrayFlow())
                .putTemporaryData("tableName", tableName)
                .putTemporaryData("instances", instances)
                .putTemporaryData("manipulationOption", manipulationOption)
                .execute();
        return getEffect(flowContext);
    }

    @Override
    public int insertIgnore(String tableName, JSONObject instance) {
        if(null==instance){
            return 0;
        }
        FlowContext flowContext = quickFlow.startFlow(new InsertIgnoreJSONObjectFlow())
                .putTemporaryData("tableName", tableName)
                .putTemporaryData("instance", instance)
                .putTemporaryData("manipulationOption", manipulationOption)
                .execute();
        return getEffect(flowContext);
    }

    @Override
    public int insertIgnore(String tableName, JSONArray instances) {
        if(null==instances||instances.isEmpty()){
            return 0;
        }
        FlowContext flowContext = quickFlow.startFlow(new InsertIgnoreJSONArrayFlow())
                .putTemporaryData("tableName", tableName)
                .putTemporaryData("instances", instances)
                .putTemporaryData("manipulationOption", manipulationOption)
                .execute();
        return getEffect(flowContext);
    }

    @Override
    public int update(String tableName, JSONObject instance) {
        if(null==instance){
            return 0;
        }
        FlowContext flowContext = quickFlow.startFlow(new UpdateJSONObjectFlow())
                .putTemporaryData("tableName", tableName)
                .putTemporaryData("instance", instance)
                .putTemporaryData("manipulationOption", manipulationOption)
                .execute();
        return getEffect(flowContext);
    }

    @Override
    public int update(String tableName, JSONArray instances) {
        if(null==instances||instances.isEmpty()){
            return 0;
        }
        FlowContext flowContext = quickFlow.startFlow(new UpdateJSONArrayFlow())
                .putTemporaryData("tableName", tableName)
                .putTemporaryData("instances", instances)
                .putTemporaryData("manipulationOption", manipulationOption)
                .execute();
        return getEffect(flowContext);
    }

    @Override
    public int save(String tableName, JSONObject instance) {
        if (null == instance) {
            return 0;
        }
        FlowContext flowContext = quickFlow.startFlow(new SaveJSONObjectFlow())
                .putTemporaryData("tableName", tableName)
                .putTemporaryData("instance", instance)
                .putTemporaryData("manipulationOption", manipulationOption)
                .execute();
        return getEffect(flowContext);
    }

    @Override
    public int save(String tableName, JSONArray instances) {
        if (null == instances || instances.isEmpty()) {
            return 0;
        }
        FlowContext flowContext = quickFlow.startFlow(new SaveJSONArrayFlow())
                .putTemporaryData("tableName", tableName)
                .putTemporaryData("instances", instances)
                .putTemporaryData("manipulationOption", manipulationOption)
                .execute();
        return getEffect(flowContext);
    }

    @Override
    public int delete(String tableName, JSONObject instance) {
        if(null==instance){
            return 0;
        }
        FlowContext flowContext = quickFlow.startFlow(new DeleteJSONObjectFlow())
                .putTemporaryData("tableName", tableName)
                .putTemporaryData("instance", instance)
                .putTemporaryData("manipulationOption", manipulationOption)
                .execute();
        return getEffect(flowContext);
    }

    @Override
    public int delete(String tableName, JSONArray instances) {
        if(null==instances||instances.isEmpty()){
            return 0;
        }
        FlowContext flowContext = quickFlow.startFlow(new DeleteJSONArrayFlow())
                .putTemporaryData("tableName", tableName)
                .putTemporaryData("instances", instances)
                .putTemporaryData("manipulationOption", manipulationOption)
                .execute();
        return getEffect(flowContext);
    }

    @Override
    public Map<Object,String> getReasonInstanceMap(Object[] instances) {
        if(null==instances||instances.length==0){
            return null;
        }
        manipulationOption.checkStrategy = CheckStrategy.CheckAndFilter;
        FlowContext flowContext = quickFlow.startFlow("获取不符合约束实例列表")
                .putTemporaryData("instances", instances)
                .putTemporaryData("manipulationOption", manipulationOption)
                .next(new SetInstanceEntityFlow())
                .next(new FilterInstanceBySameUniqueKeyFlow())
                .next(new FilterInstanceByConstraintFlow())
                .execute();
        Map<Object,String> instanceReasonMap = (Map<Object,String>) flowContext.getData("instanceReasonMap");
        return instanceReasonMap;
    }

    @Override
    public int insert(Object instance) {
        if (null == instance) {
            return 0;
        }
        FlowContext flowContext = quickFlow.startFlow(new InsertInstanceFlow())
                .putData("instance", instance)
                .putData("manipulationOption", manipulationOption)
                .execute();
        return getEffect(flowContext);
    }

    @Override
    public int insert(Object[] instances) {
        if (null == instances || instances.length == 0) {
            return 0;
        }
        FlowContext flowContext = quickFlow.startFlow(new InsertInstanceArrayFlow())
                .putData("instances", instances)
                .putData("manipulationOption", manipulationOption)
                .execute();
        return getEffect(flowContext);
    }

    @Override
    public int insert(Collection instanceCollection) {
        if (null == instanceCollection || instanceCollection.size() == 0) {
            return 0;
        }
        return insert(instanceCollection.toArray(new Object[0]));
    }

    @Override
    public int insertIgnore(Object instance) {
        if (null == instance) {
            return 0;
        }
        FlowContext flowContext = quickFlow.startFlow(new InsertIgnoreInstanceFlow())
                .putData("instance", instance)
                .putData("manipulationOption", manipulationOption)
                .execute();
        return getEffect(flowContext);
    }

    @Override
    public int insertIgnore(Object[] instances) {
        if (null == instances || instances.length == 0) {
            return 0;
        }
        FlowContext flowContext = quickFlow.startFlow(new InsertIgnoreInstanceArrayFlow())
                .putData("instances", instances)
                .putData("manipulationOption", manipulationOption)
                .execute();
        return getEffect(flowContext);
    }

    @Override
    public int insertIgnore(Collection instanceCollection) {
        return insertIgnore(instanceCollection.toArray(new Object[0]));
    }

    @Override
    public int update(Object instance) {
        if (null == instance) {
            return 0;
        }
        FlowContext flowContext = quickFlow.startFlow(new UpdateInstanceFlow())
                .putData("instance", instance)
                .putData("manipulationOption", manipulationOption)
                .execute();
        return getEffect(flowContext);
    }

    @Override
    public int update(Object[] instances) {
        if (null == instances || instances.length == 0) {
            return 0;
        }
        FlowContext flowContext = quickFlow.startFlow(new UpdateInstanceArrayFlow())
                .putData("instances", instances)
                .putData("manipulationOption", manipulationOption)
                .execute();
        return getEffect(flowContext);
    }

    @Override
    public int update(Collection instanceCollection) {
        if (null == instanceCollection || instanceCollection.size() == 0) {
            return 0;
        }
        return update(instanceCollection.toArray(new Object[0]));
    }

    @Override
    public int save(Object instance) {
        if (null == instance) {
            return 0;
        }
        FlowContext flowContext = quickFlow.startFlow(new SaveInstanceFlow())
                .putData("instance", instance)
                .putData("manipulationOption", manipulationOption)
                .execute();
        return getEffect(flowContext);
    }

    @Override
    public int save(Object[] instances) {
        if (null == instances || instances.length == 0) {
            return 0;
        }
        FlowContext flowContext = quickFlow.startFlow(new SaveInstanceArrayFlow())
                .putData("instances", instances)
                .putData("manipulationOption", manipulationOption)
                .execute();
        return getEffect(flowContext);
    }

    @Override
    public int save(Collection instanceCollection) {
        if (null == instanceCollection || instanceCollection.size() == 0) {
            return 0;
        }
        return save(instanceCollection.toArray(new Object[0]));
    }

    @Override
    public int delete(Object instance) {
        if (null == instance) {
            return 0;
        }
        FlowContext flowContext = quickFlow.startFlow(new DeleteInstanceFlow())
                .putData("instance", instance)
                .putData("manipulationOption", manipulationOption)
                .execute();
        return getEffect(flowContext);
    }

    @Override
    public int delete(Object[] instances) {
        if (null == instances || instances.length == 0) {
            return 0;
        }
        FlowContext flowContext = quickFlow.startFlow(new DeleteInstanceArrayFlow())
                .putData("instances", instances)
                .putTemporaryData("manipulationOption", manipulationOption)
                .execute();
        return getEffect(flowContext);
    }

    @Override
    public int delete(Collection instanceCollection) {
        if (null == instanceCollection || instanceCollection.size() == 0) {
            return 0;
        }
        return delete(instanceCollection.toArray(new Object[0]));
    }

    @Override
    public int delete(Class clazz, long id) {
        Entity entity = quickDAOConfig.getEntityByClassName(clazz.getName());
        return delete(clazz, entity.id.column, id);
    }

    @Override
    public int delete(Class clazz, String id) {
        Entity entity = quickDAOConfig.getEntityByClassName(clazz.getName());
        return delete(clazz, entity.id.column, id);
    }

    @Override
    public int delete(Class clazz, String field, Object value) {
        Entity entity = quickDAOConfig.getEntityByClassName(clazz.getName());
        String columnName = entity.getColumnNameByFieldName(field);
        return delete(entity.tableName, columnName, value);
    }

    @Override
    public int delete(String tableName, String columnName, Object value) {
        int effect = rawUpdate("delete from " + quickDAOConfig.databaseContext.databaseProvider.escape(tableName) + " where " + quickDAOConfig.databaseContext.databaseProvider.escape(columnName) + " = ?", value);
        return effect;
    }

    @Override
    public <T> int delete(Class<T> clazz, SFunction<T, ?> field, Object value) {
        String fieldName = LambdaUtils.resolveLambdaProperty(field);
        return delete(clazz, fieldName, value);
    }

    @Override
    public int clear(Class clazz) {
        Entity entity = quickDAOConfig.getEntityByClassName(clazz.getName());
        int effect = rawUpdate("delete from " + quickDAOConfig.databaseContext.databaseProvider.escape(entity.tableName));
        return effect;
    }

    @Override
    public int truncate(Class clazz) {
        Entity entity = quickDAOConfig.getEntityByClassName(clazz.getName());
        return truncate(entity.tableName);
    }

    @Override
    public int truncate(String tableName) {
        FlowContext flowContext = quickFlow.startFlow(new TruncateTableFlow())
                .putCurrentCompositeFlowData("tableName", tableName)
                .execute();
        int effect = (int) flowContext.checkData("effect");
        return effect;
    }

    @Override
    public int rawUpdate(String updateSQL, Object... parameters) {
        FlowContext flowContext = quickFlow.startFlow(new ExecuteUpdateConnectionFlow())
                .putTemporaryData("name", "用户自定义更新")
                .putTemporaryData("sql", updateSQL)
                .putTemporaryData("parameters", Arrays.asList(parameters))
                .execute();
        int effect = (int) flowContext.checkData("effect");
        return effect;
    }

    @Override
    public int rawUpdateBatch(String updateSQL, List<List<Object>> parameterBatchList) {
        FlowContext flowContext = quickFlow.startFlow(new ExecuteBatchUpdateConnectionFlow())
                .putTemporaryData("name", "用户自定义批处理")
                .putTemporaryData("sql", updateSQL)
                .putTemporaryData("size", parameterBatchList.size())
                .putTemporaryData("getBatchParametersSupplier",new GetBatchParametersSupplier() {
                    @Override
                    public List<Object> getBatchParameters(Integer index) throws Exception {
                        return parameterBatchList.get(index);
                    }
                })
                .execute();
        int effect = (int) flowContext.checkData("effect");
        return effect;
    }

    private int getEffect(FlowContext flowContext){
        return (int) flowContext.checkData("effect");
    }
}
