package cn.schoolwow.quickdao.dao.dcl;

import cn.schoolwow.quickdao.dao.sql.DatabaseDAOImpl;
import cn.schoolwow.quickdao.domain.external.QuickDAOConfig;
import cn.schoolwow.quickdao.domain.external.dcl.DataBaseUser;
import cn.schoolwow.quickdao.domain.external.dcl.GrantOption;
import cn.schoolwow.quickdao.flow.dcl.*;
import cn.schoolwow.quickflow.QuickFlow;
import cn.schoolwow.quickflow.domain.FlowContext;

import java.util.List;

public class DatabaseControlImpl extends DatabaseDAOImpl implements DatabaseControl {

    public DatabaseControlImpl(QuickFlow quickFlow, QuickDAOConfig quickDAOConfig) {
        super(quickFlow, quickDAOConfig);
    }

    @Override
    public List<String> getUserNameList() {
        FlowContext flowContext = quickFlow.executeFlow(new GetUserNameListFlow());
        List<String> userNameList = (List<String>) flowContext.getData("userNameList");
        return userNameList;
    }

    @Override
    public boolean hasUserName(String username) {
        List<String> userNameList = getUserNameList();
        for(String username1:userNameList){
            if(username1.equalsIgnoreCase(username)){
                return true;
            }
        }
        return false;
    }

    @Override
    public void createUser(DataBaseUser dataBaseUser) {
        quickFlow.startFlow(new CreateUserFlow())
                .putReturnData("dataBaseUser", dataBaseUser)
                .execute();
    }

    @Override
    public void modifyPassword(String username, String newPassword) {
        quickFlow.startFlow(new ModifyPasswordFlow())
                .putReturnData("username", username)
                .putReturnData("newPassword", newPassword)
                .execute();
    }

    @Override
    public void deleteUser(DataBaseUser dataBaseUser) {
        quickFlow.startFlow(new DeleteUserFlow())
                .putReturnData("dataBaseUser", dataBaseUser)
                .execute();
    }

    @Override
    public void grant(GrantOption grantOption) {
        quickFlow.startFlow(new GrantFlow())
                .putReturnData("grantOption", grantOption)
                .execute();
    }

    @Override
    public void createUserAndGrant(GrantOption grantOption) {
        quickFlow.startFlow(new CreateUserAndGrantFlow())
                .putReturnData("grantOption", grantOption)
                .execute();
    }

    @Override
    public void revoke(GrantOption grantOption) {
        quickFlow.startFlow(new RevokeFlow())
                .putReturnData("grantOption", grantOption)
                .execute();
    }

    @Override
    public void flushPrivileges() {
        quickFlow.executeFlow(new FlushPrivilegesFlow());
    }
}