package cn.schoolwow.quickdao.annotation;

import cn.schoolwow.quickdao.domain.internal.DatabaseType;

import java.lang.annotation.*;

@Target(ElementType.FIELD)
@Retention(RetentionPolicy.RUNTIME)
@Repeatable(ColumnTypeRepeatable.class)
public @interface ColumnType {
    /**
     * 表示数据库类型
     */
    String value();

    /**
     * 指定数据库类型
     * */
    DatabaseType databaseType() default DatabaseType.CURRENT;
}
