package cn.schoolwow.quickdao.flow.upgrade;

import cn.schoolwow.quickdao.dao.DAO;
import cn.schoolwow.quickdao.domain.external.Entity;
import cn.schoolwow.quickdao.domain.external.entity.DatabaseUpgrade;
import cn.schoolwow.quickdao.domain.internal.dml.ManipulationOption;
import cn.schoolwow.quickdao.flow.dml.instance.insert.common.SetInsertInstanceParameterFlow;
import cn.schoolwow.quickdao.flow.dml.instance.insert.common.SetInsertInstanceStatementFlow;
import cn.schoolwow.quickdao.flow.dql.fetch.FetchListFlow;
import cn.schoolwow.quickdao.flow.executor.ExecuteUpdateConnectionFlow;
import cn.schoolwow.quickdao.flow.executor.common.UpdateLogFlow;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import com.alibaba.fastjson.JSONArray;

import java.util.function.Consumer;

public class DatabaseUpgradeFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        DAO dao = (DAO) flowContext.checkData("dao");
        String comment = (String) flowContext.checkData("comment");
        Consumer<DAO> daoConsumer = (Consumer<DAO>) flowContext.checkData("daoConsumer");

        Entity entity = dao.getEntity(DatabaseUpgrade.class);
        if(null==entity){
            throw new IllegalArgumentException("日志类信息获取失败!日志类名:"+DatabaseUpgrade.class.getName());
        }
        flowContext.startFlow(new FetchListFlow())
                .putTemporaryData("entity", entity)
                .putTemporaryData("column", "comment")
                .putTemporaryData("value", comment)
                .execute();
        JSONArray resultSetArray = (JSONArray) flowContext.getData("resultSetArray");
        DatabaseUpgrade databaseUpgrade = resultSetArray.isEmpty()?null:resultSetArray.toJavaList(DatabaseUpgrade.class).get(0);
        if(null!=databaseUpgrade){
            if(!databaseUpgrade.isSuccess()){
                daoConsumer.accept(dao);
                databaseUpgrade.setSuccess(true);
                dao.getQuickDAOConfig().quickFlow.startFlow(new UpdateLogFlow())
                        .putTemporaryData("instance", databaseUpgrade)
                        .execute();
            }
            return;
        }
        databaseUpgrade = new DatabaseUpgrade();
        databaseUpgrade.setComment(comment);
        dao.startRecord();
        try {
            daoConsumer.accept(dao);
            databaseUpgrade.setSuccess(true);
        }catch (Exception e){
            databaseUpgrade.setSuccess(false);
            throw e;
        }finally {
            String sql = dao.stopRecord();
            databaseUpgrade.setSql(sql);

            ManipulationOption manipulationOption = new ManipulationOption();
            manipulationOption.returnGeneratedKeys = false;
            dao.getQuickDAOConfig().quickFlow.startFlow("插入数据库升级语句")
                    .putTemporaryData("insertSqlLog", false)
                    .putTemporaryData("name", "插入数据库升级语句")
                    .putTemporaryData("manipulationOption", manipulationOption)
                    .putTemporaryData("entity", entity)
                    .putTemporaryData("instance", databaseUpgrade)
                    .next(new SetInsertInstanceStatementFlow())
                    .next(new SetInsertInstanceParameterFlow())
                    .next(new ExecuteUpdateConnectionFlow())
                    .execute();
        }
    }

    @Override
    public String name() {
        return "数据库升级";
    }
}
