package cn.schoolwow.quickdao.flow.initial;

import cn.schoolwow.quickdao.domain.external.Entity;
import cn.schoolwow.quickdao.domain.external.IndexField;
import cn.schoolwow.quickdao.domain.external.Property;
import cn.schoolwow.quickdao.domain.external.QuickDAOConfig;
import cn.schoolwow.quickdao.flow.ddl.common.DeleteDatabaseEntityCacheFlow;
import cn.schoolwow.quickdao.flow.ddl.index.CreateIndexFlow;
import cn.schoolwow.quickdao.flow.ddl.property.CreateTableColumnFlow;
import cn.schoolwow.quickdao.flow.ddl.table.CreateForeignKeyFlow;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;

import java.util.List;

public class CompareAndCreateColumnFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        QuickDAOConfig quickDAOConfig = (QuickDAOConfig) flowContext.checkData("quickDAOConfig");
        Entity entity = (Entity) flowContext.checkData("entity");

        Entity databaseEntity = quickDAOConfig.getDatabaseEntityByTableName(entity.tableName);
        if(null==databaseEntity){
            return;
        }
        if(!databaseEntity.tableName.equalsIgnoreCase(entity.tableName)){
            throw new IllegalArgumentException("实体类获取错误!预期表名:"+entity.tableName+",实际表名:"+databaseEntity.tableName);
        }
        List<Property> sourcePropertyList = entity.properties;
        for (Property sourceProperty : sourcePropertyList) {
            Property targetProperty = databaseEntity.getPropertyByFieldNameOrColumnName(sourceProperty.column);
            if (null == targetProperty) {
                flowContext.startFlow(new CreateTableColumnFlow())
                        .next(new DeleteDatabaseEntityCacheFlow())
                        .putData("tableName", databaseEntity.tableName)
                        .putData("propertyOption", sourceProperty)
                        .execute();
            }
            if (null != sourceProperty.foreignKey && quickDAOConfig.databaseOption.openForeignKey) {
                flowContext.startFlow(new CreateForeignKeyFlow())
                        .next(new DeleteDatabaseEntityCacheFlow())
                        .putData("tableName", databaseEntity.tableName)
                        .putData("propertyOption", sourceProperty)
                        .execute();
            }
        }
        //判断索引是否有新增
        for (IndexField indexField : entity.indexFieldList) {
            if (null == databaseEntity.getIndexFieldByIndexName(indexField.indexName)) {
                flowContext.startFlow(new CreateIndexFlow())
                        .next(new DeleteDatabaseEntityCacheFlow())
                        .putData("indexField", indexField)
                        .putData("tableName", entity.tableName)
                        .execute();
            }
        }
    }

    @Override
    public String name() {
        return "比较并创建实体类列";
    }
}
