package cn.schoolwow.quickdao.flow.initial;

import cn.schoolwow.quickdao.dao.DAO;
import cn.schoolwow.quickdao.domain.external.QuickDAOConfig;
import cn.schoolwow.quickdao.flow.upgrade.DatabaseUpgradeFlow;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;

import java.util.Map;
import java.util.function.Consumer;

public class AfterAutomaticCreateFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        QuickDAOConfig quickDAOConfig = (QuickDAOConfig) flowContext.checkData("quickDAOConfig");
        if(quickDAOConfig.upgradeOption.afterAutomaticCreate.isEmpty()){
            flowContext.remark("跳过在自动建表语句之后执行语句");
            return;
        }
        for(Map.Entry<String, Consumer<DAO>> entry:quickDAOConfig.upgradeOption.afterAutomaticCreate.entrySet()){
            flowContext.startFlow(new DatabaseUpgradeFlow())
                    .putTemporaryData("comment", entry.getKey())
                    .putTemporaryData("daoConsumer", entry.getValue())
                    .execute();
        }
    }

    @Override
    public String name() {
        return "自动建表语句执行之前";
    }
}
