package cn.schoolwow.quickdao.flow.handler;

import cn.schoolwow.quickdao.domain.external.QuickDAOConfig;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.listener.TryCatchFinallyHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.sql.Connection;

public class QuickDAOTryCatchFinallyHandler implements TryCatchFinallyHandler {
    private Logger logger = LoggerFactory.getLogger(QuickDAOTryCatchFinallyHandler.class);

    private Connection transactionConnection;
    private QuickDAOConfig quickDAOConfig;

    public QuickDAOTryCatchFinallyHandler(Connection transactionConnection, QuickDAOConfig quickDAOConfig) {
        this.transactionConnection = transactionConnection;
        this.quickDAOConfig = quickDAOConfig;
    }

    @Override
    public void handleTry(FlowContext flowContext) throws Exception {
        flowContext.printTrace(quickDAOConfig.logRecordOption.recordFlowLog);
        flowContext.putData("transactionConnection", transactionConnection);
        flowContext.putData("quickDAOConfig", quickDAOConfig);
        flowContext.putData("databaseType", quickDAOConfig.databaseContext.databaseProvider.getDatabaseType());
    }

    @Override
    public void handleException(FlowContext flowContext, Exception e) {
        e.printStackTrace();
    }

    @Override
    public void handleFinally(FlowContext flowContext) {
        if(null!=flowContext.getFlowException()||quickDAOConfig.logRecordOption.recordFlowLog){
            logger.info("\r\n"+flowContext.getFlowTrace());
        }
    }

    @Override
    public String name() {
        return "QuickDAO全局事件";
    }
}
