package cn.schoolwow.quickdao.flow.executor.common;

import cn.schoolwow.quickdao.domain.internal.dql.common.QueryContext;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.List;

public class ExecuteFailFlow implements BusinessFlow {
    private Logger logger = LoggerFactory.getLogger(ExecuteFailFlow.class);

    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        printLog(flowContext);
        printQueryContext(flowContext);
        printException(flowContext);
    }

    @Override
    public String name() {
        return "SQL语句执行发生异常时";
    }

    private void printLog(FlowContext flowContext){
        String name = (String) flowContext.checkData("name");
        String sql = (String) flowContext.checkData("sql");
        List<Object> parameters = (List<Object>) flowContext.getData("parameters");
        String formatSQL = (String) flowContext.checkData("formatSQL");

        logger.warn("SQL语句执行失败\r\n名称:{}\r\n原始SQL:{}\r\n格式化SQL:{}\r\n参数列表:{}", name, sql, formatSQL, parameters);
    }

    private void printQueryContext(FlowContext flowContext){
        QueryContext queryContext = (QueryContext) flowContext.getData("queryContext");

        if(null==queryContext){
            return;
        }
        logger.warn("queryContext语句部分\r\n{}", queryContext);
    }

    private void printException(FlowContext flowContext){
        Exception e = (Exception) flowContext.checkData("exception");
        e.printStackTrace();
    }
}
