package cn.schoolwow.quickdao.flow.executor.common;

import cn.schoolwow.quickdao.domain.internal.dml.GetBatchParametersSupplier;
import cn.schoolwow.quickdao.util.ParametersUtil;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.List;

public class BeforeExecuteFlow implements BusinessFlow {
    private Logger logger = LoggerFactory.getLogger(BeforeExecuteFlow.class);

    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        checkParameterCount(flowContext);
        setFormatSQL(flowContext);
    }

    @Override
    public String name() {
        return "执行SQL语句之前";
    }

    private void checkParameterCount(FlowContext flowContext){
        GetBatchParametersSupplier getBatchParametersSupplier = (GetBatchParametersSupplier) flowContext.getData("getBatchParametersSupplier");
        if(null!=getBatchParametersSupplier){
            //批处理更新语句此时不检查参数个数
            return;
        }

        String name = (String) flowContext.checkData("name");
        String sql = (String) flowContext.checkData("sql");
        List<Object> parameters = (List) flowContext.getData("parameters");

        //检查参数列表个数是否匹配
        int expectParameterCount = 0;
        for(int i=0;i<sql.length();i++){
            if(sql.charAt(i)=='?'){
                expectParameterCount++;
            }
        }
        long actualParameterCount = null==parameters?0:parameters.size();
        if(expectParameterCount>0&&actualParameterCount!=expectParameterCount){
            logger.warn("SQL语句参数个数不匹配\r\n名称:{}\r\n原始SQL:{}\r\n参数列表:{}", name, sql, parameters);
            throw new IllegalArgumentException("SQL语句参数个数不匹配!预期个数:"+expectParameterCount+",实际个数:"+actualParameterCount);
        }
    }

    private void setFormatSQL(FlowContext flowContext){
        String sql = (String) flowContext.checkData("sql");
        List<Object> parameters = (List) flowContext.getData("parameters");

        //由于一个方法可能在内部调用多次executeQuery或者executeUpdate,执行sql前检查参数是否需要清空
        if(!sql.contains("?")&&null!=parameters&&!parameters.isEmpty()){
            parameters = null;
        }

        String formatSQL = ParametersUtil.getFormatSQL(sql, parameters);
        flowContext.putTemporaryData("formatSQL", formatSQL);
    }
}
