package cn.schoolwow.quickdao.flow.dql.response.common;

import cn.schoolwow.quickdao.domain.internal.dql.common.QueryContext;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;

public class SetConditionStatementFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        QueryContext queryContext = (QueryContext) flowContext.checkData("queryContext");

        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append(queryContext.select);
        sqlBuilder.append(queryContext.from);
        sqlBuilder.append(queryContext.join);
        sqlBuilder.append(queryContext.where);
        sqlBuilder.append(queryContext.groupBy);
        sqlBuilder.append(queryContext.having);
        sqlBuilder.append(queryContext.orderBy);
        sqlBuilder.append(queryContext.limit);
        flowContext.putTemporaryData("sql", sqlBuilder.toString());
    }

    @Override
    public String name() {
        return "设置复杂查询语句和参数";
    }

}
