package cn.schoolwow.quickdao.flow.dql.response;

import cn.schoolwow.quickdao.domain.external.Property;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;

public class GetSingleColumnListFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        JSONArray resultSetArray = (JSONArray) flowContext.getData("resultSetArray");
        Property[] resultSetPropertyArray = (Property[]) flowContext.checkData("resultSetPropertyArray");
        Property property = resultSetPropertyArray[0];

        if(null==resultSetArray||resultSetArray.isEmpty()){
            flowContext.putData("array", resultSetArray);
            return;
        }
        JSONArray array = new JSONArray();
        for(int i=0;i<resultSetArray.size();i++){
            JSONObject resultSetObject = resultSetArray.getJSONObject(i);
            array.add(resultSetObject.get(property.columnLabel));
        }
        flowContext.putData("array", array);
    }

    @Override
    public String name() {
        return "执行复杂查询获取单列";
    }

}
