package cn.schoolwow.quickdao.flow.dql.exist.common;

import cn.schoolwow.quickdao.domain.external.Entity;
import cn.schoolwow.quickdao.domain.external.Property;
import cn.schoolwow.quickdao.domain.external.QuickDAOConfig;
import cn.schoolwow.quickdao.domain.internal.common.ResultSetConsumer;
import cn.schoolwow.quickdao.flow.executor.ExecuteQueryConnectionFlow;
import cn.schoolwow.quickdao.util.ParametersUtil;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;

public class GetCountByUniqueKeyFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        setStatement(flowContext);
        setParameters(flowContext);
        executeStatement(flowContext);
    }

    @Override
    public String name() {
        return "根据唯一性约束查询记录个数";
    }

    private void setStatement(FlowContext flowContext) {
        QuickDAOConfig quickDAOConfig = (QuickDAOConfig) flowContext.checkData("quickDAOConfig");
        Entity entity = (Entity) flowContext.checkData("entity");
        
        String key = "selectCountByUniqueKey_" + entity.tableName + "_" + quickDAOConfig.databaseContext.databaseProvider.name();
        if (!quickDAOConfig.databaseContext.statementCache.containsKey(key)) {
            StringBuilder sqlBuilder = new StringBuilder();
            sqlBuilder.append("select count(1) from " + quickDAOConfig.databaseContext.databaseProvider.escape(entity.tableName) + " where ");
            for (Property property : entity.uniqueProperties) {
                sqlBuilder.append(quickDAOConfig.databaseContext.databaseProvider.escape(property.column) + "= " + (null == property.function ? "?" : property.function) + " and ");
            }
            sqlBuilder.delete(sqlBuilder.length() - 5, sqlBuilder.length());
            quickDAOConfig.databaseContext.statementCache.put(key, sqlBuilder.toString());
        }
        String sql = quickDAOConfig.databaseContext.statementCache.get(key);
        flowContext.putTemporaryData("sql", sql);
    }

    private void setParameters(FlowContext flowContext) {
        Entity entity = (Entity) flowContext.checkData("entity");
        Object instance = flowContext.checkData("instance");

        List<Object> parameters = new ArrayList();
        for (Property property : entity.uniqueProperties) {
            Object value = ParametersUtil.getFieldValueFromInstance(instance, property.name);
            parameters.add(value);
        }
        flowContext.putTemporaryData("parameters", parameters);
    }

    private void executeStatement(FlowContext flowContext){
        flowContext.startFlow(new ExecuteQueryConnectionFlow())
                .putTemporaryData("name", "根据唯一性约束查询记录个数")
                .putTemporaryData("resultSetConsumer", new ResultSetConsumer() {
                    @Override
                    public void consumeResultSet(ResultSet resultSet) throws Exception {
                        if(resultSet.next()){
                            flowContext.putData("count", resultSet.getLong(1));
                        }
                    }
                })
                .execute();
    }

}
