package cn.schoolwow.quickdao.flow.dql.exist.common;

import cn.schoolwow.quickdao.domain.external.Entity;
import cn.schoolwow.quickdao.domain.external.QuickDAOConfig;
import cn.schoolwow.quickdao.domain.internal.common.ResultSetConsumer;
import cn.schoolwow.quickdao.flow.executor.ExecuteQueryConnectionFlow;
import cn.schoolwow.quickdao.util.ParametersUtil;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;

import java.sql.ResultSet;
import java.util.Arrays;

public class GetCountByIdFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        setStatement(flowContext);
        setParameters(flowContext);
        executeStatement(flowContext);
    }

    @Override
    public String name() {
        return "根据id字段查询记录个数";
    }

    private void setStatement(FlowContext flowContext) {
        QuickDAOConfig quickDAOConfig = (QuickDAOConfig) flowContext.checkData("quickDAOConfig");
        Entity entity = (Entity) flowContext.checkData("entity");
        
        String key = "selectCountById_" + entity.tableName + "_" + quickDAOConfig.databaseContext.databaseProvider.name();
        if (!quickDAOConfig.databaseContext.statementCache.containsKey(key)) {
            StringBuilder sqlBuilder = new StringBuilder();
            sqlBuilder.append("select count(1) from " + quickDAOConfig.databaseContext.databaseProvider.escape(entity.tableName) + " where ");
            sqlBuilder.append(quickDAOConfig.databaseContext.databaseProvider.escape(entity.id.column) + " = ?");
            quickDAOConfig.databaseContext.statementCache.put(key, sqlBuilder.toString());
        }
        String sql = quickDAOConfig.databaseContext.statementCache.get(key);
        flowContext.putTemporaryData("sql", sql);
    }

    private void setParameters(FlowContext flowContext) {
        Entity entity = (Entity) flowContext.checkData("entity");
        Object instance = flowContext.checkData("instance");

        Object idValue = ParametersUtil.getFieldValueFromInstance(instance, entity.id.name);
        flowContext.putTemporaryData("parameters", Arrays.asList(idValue));
    }

    private void executeStatement(FlowContext flowContext){
        flowContext.startFlow(new ExecuteQueryConnectionFlow())
                .putTemporaryData("name", "根据Id字段查询记录个数")
                .putTemporaryData("resultSetConsumer", new ResultSetConsumer() {
                    @Override
                    public void consumeResultSet(ResultSet resultSet) throws Exception {
                        if(resultSet.next()){
                            flowContext.putData("count", resultSet.getLong(1));
                        }
                    }
                })
                .execute();
    }

}
