package cn.schoolwow.quickdao.flow.dql.exist;

import cn.schoolwow.quickdao.domain.external.Entity;
import cn.schoolwow.quickdao.flow.dml.instance.common.SetInstanceEntityFlow;
import cn.schoolwow.quickdao.flow.dql.exist.common.GetCountByIdFlow;
import cn.schoolwow.quickdao.flow.dql.exist.common.GetCountByUniqueKeyFlow;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;

public class GetInstanceCountFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        flowContext.executeFlowList(new SetInstanceEntityFlow());
        Entity entity = (Entity) flowContext.checkData("entity");
        Object instance = flowContext.checkData("instance");

        if(!entity.uniqueProperties.isEmpty()){
            flowContext.executeFlowList(new GetCountByUniqueKeyFlow());
        }else if(null!=entity.id){
            flowContext.executeFlowList(new GetCountByIdFlow());
        }else{
            throw new IllegalArgumentException("该实例无唯一性约束又无id值,无法判断!类名:" + instance.getClass().getName());
        }
    }

    @Override
    public String name() {
        return "获取实例在数据库中的个数";
    }
}
