package cn.schoolwow.quickdao.flow.dql.condition.common;

import cn.schoolwow.quickdao.domain.internal.DatabaseType;
import cn.schoolwow.quickdao.domain.internal.dql.common.QueryContext;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;

public class BeforeExecuteConditionFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        DatabaseType databaseType = (DatabaseType) flowContext.checkData("databaseType");
        QueryContext queryContext = (QueryContext) flowContext.checkData("queryContext");

        switch (databaseType){
            case SQLServer:{
                //SQL Server的分页和排序必须一起用
                if ((queryContext.queryOption.queryFragmentOption.orderByList.size() > 0 && queryContext.queryOption.queryPagingOption.limit.isEmpty())
                        || (queryContext.queryOption.queryFragmentOption.orderByList.size() == 0 && !queryContext.queryOption.queryPagingOption.limit.isEmpty())) {
                    throw new IllegalArgumentException("SQL Server的排序和分页操作必须一起使用!");
                }
            }break;
        }
    }

    @Override
    public String name() {
        return "执行Condition前检查";
    }
}
