package cn.schoolwow.quickdao.flow.dml.json.update.common;

import cn.schoolwow.quickdao.domain.external.QuickDAOConfig;
import cn.schoolwow.quickdao.domain.internal.dml.ManipulationOption;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;

import java.util.List;

public class SetUpdateJSONObjectStatementFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        QuickDAOConfig quickDAOConfig = (QuickDAOConfig) flowContext.checkData("quickDAOConfig");
        ManipulationOption manipulationOption = (ManipulationOption) flowContext.checkData("manipulationOption");
        String tableName = (String) flowContext.checkData("tableName");
        List<String> columnNameList = (List<String>) flowContext.checkData("columnNameList");

        StringBuilder sqlBuilder = new StringBuilder("update " + quickDAOConfig.databaseContext.databaseProvider.escape(tableName) + " set ");
        for(String columnName:columnNameList){
            sqlBuilder.append(quickDAOConfig.databaseContext.databaseProvider.escape(columnName) + " = ?,");
        }
        sqlBuilder.deleteCharAt(sqlBuilder.length() - 1);
        sqlBuilder.append(" where");
        for(String uniqueFieldName:manipulationOption.uniqueFieldNames){
            sqlBuilder.append(" "+quickDAOConfig.databaseContext.databaseProvider.escape(uniqueFieldName) + " = ? and");
        }
        sqlBuilder.delete(sqlBuilder.length()-4,sqlBuilder.length());
        flowContext.putTemporaryData("sql", sqlBuilder.toString());
    }

    @Override
    public String name() {
        return "设置更新JSONObject的SQL语句";
    }

}
