package cn.schoolwow.quickdao.flow.dml.json.update;

import cn.schoolwow.quickdao.flow.dml.json.common.SetColumnNameListFlow;
import cn.schoolwow.quickdao.flow.dml.json.common.check.CheckUniqueFieldNameFlow;
import cn.schoolwow.quickdao.flow.dml.json.update.common.SetUpdateJSONObjectParameterFlow;
import cn.schoolwow.quickdao.flow.dml.json.update.common.SetUpdateJSONObjectStatementFlow;
import cn.schoolwow.quickdao.flow.executor.ExecuteUpdateConnectionFlow;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;

public class UpdateJSONObjectFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        flowContext.startFlow("更新JSONObject")
                .next(new CheckUniqueFieldNameFlow())
                .next(new SetColumnNameListFlow())
                .next(new SetUpdateJSONObjectStatementFlow())
                .next(new SetUpdateJSONObjectParameterFlow())
                .next(new ExecuteUpdateConnectionFlow())
                .putTemporaryData("name", "更新JSONObject")
                .execute();
    }

    @Override
    public String name() {
        return "更新JSONObject";
    }

}
