package cn.schoolwow.quickdao.flow.dml.json.insert;

import cn.schoolwow.quickdao.domain.internal.dml.GetBatchParametersSupplier;
import cn.schoolwow.quickdao.domain.internal.dml.ManipulationOption;
import cn.schoolwow.quickdao.flow.dml.common.CheckReasonInstanceMapFlow;
import cn.schoolwow.quickdao.flow.dml.json.common.SetJSONObjectEntityFlow;
import cn.schoolwow.quickdao.flow.dml.json.common.filter.FilterJSONArrayByConstraintFlow;
import cn.schoolwow.quickdao.flow.dml.json.common.filter.FilterJSONArrayBySameUniqueFieldFlow;
import cn.schoolwow.quickdao.flow.dml.json.insert.common.ExecuteInsertJSONObjectFlow;
import cn.schoolwow.quickdao.flow.dml.json.insert.common.SetInsertJSONObjectParameterFlow;
import cn.schoolwow.quickdao.flow.dml.json.insert.common.SetInsertJSONObjectStatementFlow;
import cn.schoolwow.quickdao.flow.executor.ExecuteBatchUpdateConnectionFlow;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;

import java.util.List;

public class InsertJSONArrayFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        flowContext.executeFlowList(
                new SetJSONObjectEntityFlow(),
                new FilterJSONArrayBySameUniqueFieldFlow(),
                new FilterJSONArrayByConstraintFlow(),
                new CheckReasonInstanceMapFlow(),
                new SetInsertJSONObjectStatementFlow()
        );
        ManipulationOption manipulationOption = (ManipulationOption) flowContext.checkData("manipulationOption");
        if(manipulationOption.batch){
            executeInsertBatch(flowContext);
        }else{
            executeInsertOneByOne(flowContext);
        }
    }

    @Override
    public String name() {
        return "插入JSONArray";
    }

    private void executeInsertBatch(FlowContext flowContext) {
        ManipulationOption manipulationOption = (ManipulationOption) flowContext.checkData("manipulationOption");
        JSONArray instances = (JSONArray) flowContext.checkData("instances");

        flowContext.startFlow(new ExecuteBatchUpdateConnectionFlow())
                .putTemporaryData("perBatchCount", manipulationOption.perBatchCount)
                .putTemporaryData("name", "批处理插入JSONArray")
                .putTemporaryData("size", instances.size())
                .putTemporaryData("getBatchParametersSupplier", new GetBatchParametersSupplier() {
                    @Override
                    public List<Object> getBatchParameters(Integer index) throws Exception {
                        JSONObject instance = instances.getJSONObject(index);
                        flowContext.putTemporaryData("instance", instance);
                        flowContext.executeFlowList(new SetInsertJSONObjectParameterFlow());
                        List<Object> parameters = (List<Object>) flowContext.checkData("parameters");
                        return parameters;
                    }
                })
                .execute();
    }

    private void executeInsertOneByOne(FlowContext flowContext) {
        int effect = 0;
        JSONArray instances = (JSONArray) flowContext.checkData("instances");
        for(int i=0;i<instances.size();i++){
            flowContext.startFlow("循环插入JSONObject "+(i+1)+"/"+instances.size())
                    .putTemporaryData("instance", instances.getJSONObject(i))
                    .next(new SetInsertJSONObjectParameterFlow())
                    .next(new ExecuteInsertJSONObjectFlow())
                    .execute();
            effect += (int)flowContext.checkData("effect");
        }
        flowContext.putData("effect", effect);
    }

}
