package cn.schoolwow.quickdao.flow.dml.instance.update.common;

import cn.schoolwow.quickdao.domain.external.Entity;
import cn.schoolwow.quickdao.domain.external.Property;
import cn.schoolwow.quickdao.domain.external.QuickDAOConfig;
import cn.schoolwow.quickdao.util.ParametersUtil;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;

import java.util.ArrayList;
import java.util.List;

public class SetUpdateInstanceByUniqueKeyParameterFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        QuickDAOConfig quickDAOConfig = (QuickDAOConfig) flowContext.checkData("quickDAOConfig");
        Entity entity = (Entity) flowContext.checkData("entity");
        List<Property> propertyList = (List<Property>) flowContext.checkData("propertyList");
        Object instance = flowContext.checkData("instance");

        List<Object> parameters = new ArrayList();
        for(Property property:propertyList){
            if (property.id || entity.uniqueProperties.contains(property)) {
                continue;
            }
            if (property.createdAt) {
                continue;
            }
            if (property.updateAt) {
                ParametersUtil.setCurrentDateTime(property, instance);
            }
            Object value = null;
            if (null != quickDAOConfig.databaseOption.updateColumnValueFunction) {
                value = quickDAOConfig.databaseOption.updateColumnValueFunction.apply(property);
            }
            if (null == value) {
                value = ParametersUtil.getFieldValueFromInstance(instance, property.name);
            }
            parameters.add(value);
        }
        for (Property property : entity.uniqueProperties) {
            Object value = ParametersUtil.getFieldValueFromInstance(instance, property.name);
            if(null==value){
                throw new IllegalArgumentException("唯一字段不能为空!实例类名:"+instance.getClass().getName()+",字段名:"+property.name);
            }
            parameters.add(value);
        }

        flowContext.putTemporaryData("parameters", parameters);
    }

    @Override
    public String name() {
        return "设置根据唯一性约束更新实例参数列表";
    }

}
