package cn.schoolwow.quickdao.flow.dml.instance.update.common;

import cn.schoolwow.quickdao.domain.external.Entity;
import cn.schoolwow.quickdao.domain.external.Property;
import cn.schoolwow.quickdao.domain.external.QuickDAOConfig;
import cn.schoolwow.quickdao.util.ParametersUtil;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;

import java.util.ArrayList;
import java.util.List;

public class SetUpdateInstanceByIdParameterFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        QuickDAOConfig quickDAOConfig = (QuickDAOConfig) flowContext.checkData("quickDAOConfig");
        Entity entity = (Entity) flowContext.checkData("entity");
        List<Property> propertyList = (List<Property>) flowContext.checkData("propertyList");
        Object instance = flowContext.checkData("instance");

        List<Object> parameters = new ArrayList();
        for(Property property:propertyList){
            if (property.id) {
                continue;
            }
            if (property.createdAt) {
                continue;
            }
            if (property.updateAt) {
                ParametersUtil.setCurrentDateTime(property, instance);
            }
            Object value = null;
            if (null != quickDAOConfig.databaseOption.updateColumnValueFunction) {
                value = quickDAOConfig.databaseOption.updateColumnValueFunction.apply(property);
            }
            if (null == value) {
                value = ParametersUtil.getFieldValueFromInstance(instance, property.name);
            }
            parameters.add(value);
        }

        Object idValue = ParametersUtil.getFieldValueFromInstance(instance, entity.id.name);
        parameters.add(idValue);

        flowContext.putTemporaryData("parameters", parameters);
    }

    @Override
    public String name() {
        return "设置根据Id更新实例参数列表";
    }

}
