package cn.schoolwow.quickdao.flow.dml.instance.insert.common;

import cn.schoolwow.quickdao.annotation.IdStrategy;
import cn.schoolwow.quickdao.domain.external.Entity;
import cn.schoolwow.quickdao.domain.external.Property;
import cn.schoolwow.quickdao.domain.external.QuickDAOConfig;
import cn.schoolwow.quickdao.domain.internal.common.GetStatementSupplier;
import cn.schoolwow.quickdao.flow.dml.instance.common.SetInstanceStatementFlow;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;

import java.util.List;

public class SetInsertInstanceStatementFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        QuickDAOConfig quickDAOConfig = (QuickDAOConfig) flowContext.checkData("quickDAOConfig");
        Entity entity = (Entity) flowContext.checkData("entity");

        flowContext.startFlow(new SetInstanceStatementFlow())
                .putTemporaryData("sqlCacheName", "insert_" + entity.tableName + "_" + quickDAOConfig.databaseContext.databaseProvider.name())
                .putTemporaryData("getStatementSupplier", new GetStatementSupplier() {
                    @Override
                    public String getStatement() {
                        List<Property> propertyList = (List<Property>) flowContext.checkData("propertyList");

                        StringBuilder sqlBuilder = new StringBuilder();
                        sqlBuilder.append("insert into " + quickDAOConfig.databaseContext.databaseProvider.escape(entity.tableName) + "(");
                        for (Property property : propertyList) {
                            if (property.id && property.strategy == IdStrategy.AutoIncrement) {
                                continue;
                            }
                            sqlBuilder.append(quickDAOConfig.databaseContext.databaseProvider.escape(property.column) + ",");
                        }
                        sqlBuilder.deleteCharAt(sqlBuilder.length() - 1);
                        sqlBuilder.append(") values(");
                        for (Property property : propertyList) {
                            if (property.id && property.strategy == IdStrategy.AutoIncrement) {
                                continue;
                            }
                            sqlBuilder.append((null == property.function ? "?" : property.function) + ",");
                        }
                        sqlBuilder.deleteCharAt(sqlBuilder.length() - 1);
                        sqlBuilder.append(")");
                        return sqlBuilder.toString();
                    }
                })
                .execute();
    }

    @Override
    public String name() {
        return "设置插入实例的SQL语句";
    }

}
