package cn.schoolwow.quickdao.flow.dml.instance.insert;

import cn.schoolwow.quickdao.domain.internal.dml.GetBatchParametersSupplier;
import cn.schoolwow.quickdao.domain.internal.dml.ManipulationOption;
import cn.schoolwow.quickdao.flow.dml.common.CheckReasonInstanceMapFlow;
import cn.schoolwow.quickdao.flow.dml.instance.common.SetGenerateKeysFlow;
import cn.schoolwow.quickdao.flow.dml.instance.common.SetInstanceEntityFlow;
import cn.schoolwow.quickdao.flow.dml.instance.common.filter.FilterInstanceByConstraintFlow;
import cn.schoolwow.quickdao.flow.dml.instance.common.filter.FilterInstanceBySameUniqueKeyFlow;
import cn.schoolwow.quickdao.flow.dml.instance.insert.common.SetInsertInstanceParameterFlow;
import cn.schoolwow.quickdao.flow.dml.instance.insert.common.SetInsertInstanceStatementFlow;
import cn.schoolwow.quickdao.flow.executor.ExecuteBatchUpdateConnectionFlow;
import cn.schoolwow.quickdao.flow.executor.ExecuteUpdateConnectionFlow;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;

import java.util.List;

public class InsertInstanceArrayFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        flowContext.executeFlowList(
                new SetInstanceEntityFlow(),
                new FilterInstanceBySameUniqueKeyFlow(),
                new FilterInstanceByConstraintFlow(),
                new CheckReasonInstanceMapFlow(),
                new SetInsertInstanceStatementFlow()
        );
        ManipulationOption manipulationOption = (ManipulationOption) flowContext.checkData("manipulationOption");
        if(manipulationOption.batch){
            executeInsertBatch(flowContext);
        }else{
            executeInsertOneByOne(flowContext);
        }
    }

    @Override
    public String name() {
        return "插入实例数组";
    }

    private void executeInsertBatch(FlowContext flowContext){
        ManipulationOption manipulationOption = (ManipulationOption) flowContext.checkData("manipulationOption");
        Object[] instances = (Object[]) flowContext.checkData("instances");

        flowContext.startFlow(new ExecuteBatchUpdateConnectionFlow())
                .putTemporaryData("perBatchCount", manipulationOption.perBatchCount)
                .putTemporaryData("name", "批处理插入实例数组")
                .putTemporaryData("size", instances.length)
                .putTemporaryData("getBatchParametersSupplier", new GetBatchParametersSupplier() {
                    @Override
                    public List<Object> getBatchParameters(Integer index) throws Exception {
                        flowContext.putTemporaryData("instance", instances[index]);
                        flowContext.executeFlowList(new SetInsertInstanceParameterFlow());
                        List<Object> parameters = (List<Object>) flowContext.checkData("parameters");
                        return parameters;
                    }
                })
                .execute();
    }

    private void executeInsertOneByOne(FlowContext flowContext){
        Object[] instances = (Object[]) flowContext.checkData("instances");
        flowContext.putTemporaryData("name", "插入实例数组");

        int effect = 0;
        for(int i=0;i<instances.length;i++){
            flowContext.startFlow("循环处理实例/"+(i+1)+"/"+instances.length)
                    .putTemporaryData("instance", instances[i])
                    .next(new SetInsertInstanceParameterFlow())
                    .next(new ExecuteUpdateConnectionFlow())
                    .next(new SetGenerateKeysFlow())
                    .execute();
            effect += (int)flowContext.checkData("effect");
        }
        flowContext.putData("effect", effect);
    }

}
