package cn.schoolwow.quickdao.flow.dml.instance.delete.common;

import cn.schoolwow.quickdao.domain.external.Entity;
import cn.schoolwow.quickdao.domain.external.Property;
import cn.schoolwow.quickdao.domain.external.QuickDAOConfig;
import cn.schoolwow.quickdao.domain.internal.common.GetStatementSupplier;
import cn.schoolwow.quickdao.domain.internal.dml.GetBatchParametersSupplier;
import cn.schoolwow.quickdao.domain.internal.dml.ManipulationOption;
import cn.schoolwow.quickdao.flow.common.GetAndCacheStatementFlow;
import cn.schoolwow.quickdao.flow.executor.ExecuteBatchUpdateConnectionFlow;
import cn.schoolwow.quickdao.util.ParametersUtil;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;

import java.util.ArrayList;
import java.util.List;

public class DeleteByMultipleUniqueKeyFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        setStatement(flowContext);
        setParameters(flowContext);
        executeStatement(flowContext);
    }

    @Override
    public String name() {
        return "根据多个唯一约束字段删除实例";
    }

    private void setStatement(FlowContext flowContext) {
        QuickDAOConfig quickDAOConfig = (QuickDAOConfig) flowContext.checkData("quickDAOConfig");
        Entity entity = (Entity) flowContext.checkData("entity");

        flowContext.startFlow(new GetAndCacheStatementFlow())
                .putTemporaryData("sqlCacheName", "deleteByMultipleUniqueKey_"+entity.tableName)
                .putTemporaryData("getStatementSupplier", new GetStatementSupplier() {
                    @Override
                    public String getStatement() {
                        StringBuilder sqlBuilder = new StringBuilder();
                        sqlBuilder.append("delete from " + quickDAOConfig.databaseContext.databaseProvider.escape(entity.tableName) + " where ");
                        for(Property uniqueKeyProperty:entity.uniqueProperties){
                            sqlBuilder.append(quickDAOConfig.databaseContext.databaseProvider.escape(uniqueKeyProperty.column) + " = ? and ");
                        }
                        sqlBuilder.deleteCharAt(sqlBuilder.length() - 4);
                        return sqlBuilder.toString();
                    }
                })
                .execute();
    }

    public void setParameters(FlowContext flowContext) {
        Entity entity = (Entity) flowContext.checkData("entity");
        Object instance = flowContext.getData("instance");

        List<Object> parameters = new ArrayList();
        for(Property uniqueProperty:entity.uniqueProperties){
            Object value = ParametersUtil.getFieldValueFromInstance(instance, uniqueProperty.name);
            if(null==value){
                throw new IllegalArgumentException("唯一约束字段不能为空!实体类:"+entity.clazz.getName()+",字段名:"+uniqueProperty.name);
            }
            parameters.add(value);
        }
        flowContext.putTemporaryData("parameters", parameters);
    }

    private void executeStatement(FlowContext flowContext) {
        ManipulationOption manipulationOption = (ManipulationOption) flowContext.checkData("manipulationOption");
        Object[] instances = (Object[]) flowContext.getData("instances", new Object[]{flowContext.checkData("instance")});

        flowContext.startFlow(new ExecuteBatchUpdateConnectionFlow())
                .putTemporaryData("perBatchCount", manipulationOption.perBatchCount)
                .putTemporaryData("name", "批处理根据唯一约束字段删除实例数组")
                .putTemporaryData("size", instances.length)
                .putTemporaryData("getBatchParametersSupplier", new GetBatchParametersSupplier() {
                    @Override
                    public List<Object> getBatchParameters(Integer index) throws Exception {
                        flowContext.putTemporaryData("instance", instances[index]);
                        setParameters(flowContext);
                        List<Object> parameters = (List<Object>) flowContext.checkData("parameters");
                        return parameters;
                    }
                })
                .execute();
    }
}
