package cn.schoolwow.quickdao.flow.ddl.table;

import cn.schoolwow.quickdao.domain.external.QuickDAOConfig;
import cn.schoolwow.quickdao.flow.executor.ExecuteUpdateConnectionFlow;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;

public class DropTableFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        QuickDAOConfig quickDAOConfig = (QuickDAOConfig) flowContext.checkData("quickDAOConfig");
        String tableName = (String) flowContext.checkData("tableName");

        flowContext.startFlow(new ExecuteUpdateConnectionFlow())
                .putTemporaryData("name", "删除表")
                .putTemporaryData("sql", "drop table " + quickDAOConfig.databaseContext.databaseProvider.escape(tableName) + ";")
                .execute();
    }

    @Override
    public String name() {
        return "删除表";
    }
}
