package cn.schoolwow.quickdao.flow.ddl.table;

import cn.schoolwow.quickdao.domain.external.PropertyOption;
import cn.schoolwow.quickdao.domain.external.QuickDAOConfig;
import cn.schoolwow.quickdao.flow.ddl.has.HasConstraintFlow;
import cn.schoolwow.quickdao.flow.executor.ExecuteUpdateConnectionFlow;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;

public class CreateForeignKeyFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        checkConstraintExist(flowContext);
        executeCreateForeignKey(flowContext);
    }

    @Override
    public String name() {
        return "创建外键约束";
    }

    private void checkConstraintExist(FlowContext flowContext) throws Exception {
        QuickDAOConfig quickDAOConfig = (QuickDAOConfig) flowContext.checkData("quickDAOConfig");
        String tableName = (String) flowContext.checkData("tableName");
        PropertyOption propertyOption = (PropertyOption) flowContext.checkData("propertyOption");

        String foreignKeyName = "FK_" + tableName + "_" + propertyOption.foreignKey.field() + "_" + quickDAOConfig.getEntityByClassName(propertyOption.foreignKey.table().getName()).tableName + "_" + propertyOption.name;
        boolean hasResult = (boolean) flowContext.startFlow(new HasConstraintFlow())
                .putTemporaryData("constraintName", foreignKeyName)
                .execute()
                .checkData("hasResult");
        if(hasResult){
            flowContext.broken("外键约束已存在");
        }else{
            flowContext.putTemporaryData("foreignKeyName", foreignKeyName);
        }
    }

    private void executeCreateForeignKey(FlowContext flowContext){
        QuickDAOConfig quickDAOConfig = (QuickDAOConfig) flowContext.checkData("quickDAOConfig");
        String tableName = (String) flowContext.checkData("tableName");
        PropertyOption propertyOption = (PropertyOption) flowContext.checkData("propertyOption");
        String foreignKeyName = (String) flowContext.checkData("foreignKeyName");

        String operation = propertyOption.foreignKey.foreignKeyOption().getOperation();
        String reference = quickDAOConfig.databaseContext.databaseProvider.escape(quickDAOConfig.getEntityByClassName(propertyOption.foreignKey.table().getName()).tableName) + "(" + quickDAOConfig.databaseContext.databaseProvider.escape(propertyOption.foreignKey.field()) + ") ON DELETE " + operation + " ON UPDATE " + operation;
        String createForeignKeySQL = "alter table " + quickDAOConfig.databaseContext.databaseProvider.escape(tableName) + " add constraint " + quickDAOConfig.databaseContext.databaseProvider.escape(foreignKeyName) + " foreign key(" + quickDAOConfig.databaseContext.databaseProvider.escape(propertyOption.column) + ") references " + reference + ";";

        flowContext.startFlow(new ExecuteUpdateConnectionFlow())
                .putTemporaryData("name", "创建外键约束")
                .putTemporaryData("sql", createForeignKeySQL)
                .execute();
    }
}
