package cn.schoolwow.quickdao.flow.ddl.property;

import cn.schoolwow.quickdao.domain.external.Property;
import cn.schoolwow.quickdao.domain.external.QuickDAOConfig;
import cn.schoolwow.quickdao.domain.internal.DatabaseType;
import cn.schoolwow.quickdao.flow.executor.ExecuteUpdateConnectionFlow;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;

public class DropTableColumnFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        checkCanAlterTableColumn(flowContext);
        dropTableColumn(flowContext);
    }

    @Override
    public String name() {
        return "删除表字段";
    }

    private void checkCanAlterTableColumn(FlowContext flowContext){
        DatabaseType databaseType = (DatabaseType) flowContext.checkData("databaseType");
        switch (databaseType){
            case SQLite:{
                throw new IllegalArgumentException("SQLite数据库不支持删除字段");
            }
        }
    }

    private void dropTableColumn(FlowContext flowContext){
        QuickDAOConfig quickDAOConfig = (QuickDAOConfig) flowContext.checkData("quickDAOConfig");

        flowContext.executeFlowList(new GetPropertyFlow());
        Property property = (Property) flowContext.getData("property");

        String tableName = (String) flowContext.checkData("tableName");
        String columnName = (String) flowContext.checkData("columnName");
        if(null==property){
            throw new IllegalArgumentException("被删除的列不存在!表名:" + tableName + ",列名:" + columnName);
        }

        flowContext.startFlow(new ExecuteUpdateConnectionFlow())
                .putTemporaryData("name", "删除列")
                .putTemporaryData("sql", "alter table " + quickDAOConfig.databaseContext.databaseProvider.escape(tableName) + " drop column " + quickDAOConfig.databaseContext.databaseProvider.escape(columnName) + ";")
                .execute();
    }
}
