package cn.schoolwow.quickdao.flow.ddl.property;

import cn.schoolwow.quickdao.annotation.IdStrategy;
import cn.schoolwow.quickdao.domain.external.PropertyOption;
import cn.schoolwow.quickdao.domain.external.QuickDAOConfig;
import cn.schoolwow.quickdao.domain.internal.DatabaseType;
import cn.schoolwow.quickdao.flow.ddl.common.GetAutoIncrementStatementFlow;
import cn.schoolwow.quickdao.flow.ddl.common.GetEscapeCheckFlow;
import cn.schoolwow.quickdao.flow.executor.ExecuteUpdateConnectionFlow;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;

public class CreateTableColumnFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        flowContext.executeFlowList(new GetEscapeCheckFlow());
        setStatement(flowContext);
        executeStatement(flowContext);
    }

    @Override
    public String name() {
        return "新增表字段";
    }
    
    private void setStatement(FlowContext flowContext){
        QuickDAOConfig quickDAOConfig = (QuickDAOConfig) flowContext.checkData("quickDAOConfig");
        String tableName = (String) flowContext.checkData("tableName");
        DatabaseType databaseType = (DatabaseType) flowContext.checkData("databaseType");
        switch (databaseType){
            case H2:{tableName = tableName.toUpperCase();}break;
        }
        PropertyOption propertyOption = (PropertyOption) flowContext.checkData("propertyOption");
        
        StringBuilder sqlBuilder = new StringBuilder("alter table " + quickDAOConfig.databaseContext.databaseProvider.escape(tableName) + " add ");
        flowContext.putTemporaryData("sqlBuilder", sqlBuilder);
        
        if (propertyOption.id && propertyOption.strategy == IdStrategy.AutoIncrement) {
            flowContext.startFlow(new GetAutoIncrementStatementFlow())
                    .putTemporaryData("propertyOption", propertyOption)
                    .execute();
        } else {
            sqlBuilder.append(quickDAOConfig.databaseContext.databaseProvider.escape(propertyOption.column) + " " + propertyOption.columnType + (null == propertyOption.range ? "" : "(" + propertyOption.range + ")"));
            if (null != propertyOption.defaultValue && !propertyOption.defaultValue.isEmpty()) {
                sqlBuilder.append(" default " + propertyOption.defaultValue);
            }
            if (null!=propertyOption.notNull&&propertyOption.notNull) {
                sqlBuilder.append(" not null");
            }
            if(flowContext.containKey("escapeCheck")){
                sqlBuilder.append(" check " + flowContext.checkData("escapeCheck"));
            }
            if (null != propertyOption.comment) {
                //sqlite不添加注释信息
                switch (databaseType){
                    case SQLite:{}break;
                    default:{
                        sqlBuilder.append(" " + quickDAOConfig.databaseContext.databaseProvider.comment(propertyOption.comment));
                    }break;
                }
            }
        }
        sqlBuilder.append(";");
        flowContext.putTemporaryData("sql", sqlBuilder.toString());
    }

    private void executeStatement(FlowContext flowContext){
        flowContext.startFlow(new ExecuteUpdateConnectionFlow())
                .putTemporaryData("name", "新增列")
                .execute();
    }
}
