package cn.schoolwow.quickdao.flow.ddl.index;

import cn.schoolwow.quickdao.domain.external.IndexField;
import cn.schoolwow.quickdao.domain.external.QuickDAOConfig;
import cn.schoolwow.quickdao.domain.internal.DatabaseType;
import cn.schoolwow.quickdao.flow.executor.ExecuteUpdateConnectionFlow;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;

public class CreateIndexFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        setStatement(flowContext);
        executeStatement(flowContext);
    }

    @Override
    public String name() {
        return "创建索引";
    }

    private void setStatement(FlowContext flowContext) {
        DatabaseType databaseType = (DatabaseType) flowContext.checkData("databaseType");
        QuickDAOConfig quickDAOConfig = (QuickDAOConfig) flowContext.checkData("quickDAOConfig");
        IndexField indexField = (IndexField) flowContext.checkData("indexField");

        StringBuilder sqlBuilder = new StringBuilder("create");
        switch (indexField.indexType) {
            case NORMAL: {
            }
            break;
            case UNIQUE: {
                sqlBuilder.append(" unique");
            }
            break;
            case FULLTEXT: {
                sqlBuilder.append(" fulltext");
            }
            break;
        }
        if(null==indexField.indexName||indexField.indexName.isEmpty()){
            StringBuilder indexNameBuilder = new StringBuilder(indexField.tableName+"_"+indexField.indexType.name().toLowerCase()+"_");
            for (String column : indexField.columns) {
                indexNameBuilder.append(column + ",");
            }
            indexNameBuilder.deleteCharAt(indexNameBuilder.length()-1);
            indexField.indexName = indexNameBuilder.toString();
        }
        sqlBuilder.append(" index " + quickDAOConfig.databaseContext.databaseProvider.escape(indexField.indexName) + " on " + quickDAOConfig.databaseContext.databaseProvider.escape(indexField.tableName) + "(");
        for (String column : indexField.columns) {
            sqlBuilder.append(quickDAOConfig.databaseContext.databaseProvider.escape(column) + ",");
        }
        sqlBuilder.deleteCharAt(sqlBuilder.length() - 1);
        sqlBuilder.append(")");
        if (null != indexField.using && !indexField.using.isEmpty()) {
            switch (databaseType){
                case SQLite:{flowContext.remark("SQLite不支持using语法");}break;
                default:{
                    sqlBuilder.append(" using " + indexField.using);
                }break;
            }
        }
        if (null != indexField.comment && !indexField.comment.isEmpty()) {
            sqlBuilder.append(" " + quickDAOConfig.databaseContext.databaseProvider.comment(indexField.comment));
        }
        sqlBuilder.append(";");
        flowContext.putTemporaryData("sql", sqlBuilder.toString());
    }

    private void executeStatement(FlowContext flowContext) {
        flowContext.startFlow(new ExecuteUpdateConnectionFlow())
                .putTemporaryData("name", "创建索引")
                .execute();
    }
}
