package cn.schoolwow.quickdao.flow.ddl.has;

import cn.schoolwow.quickdao.domain.external.Entity;
import cn.schoolwow.quickdao.domain.external.QuickDAOConfig;
import cn.schoolwow.quickdao.domain.internal.DatabaseType;
import cn.schoolwow.quickdao.flow.ddl.has.common.SetHasResultSetFlow;
import cn.schoolwow.quickdao.flow.executor.ExecuteQueryConnectionFlow;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;

import java.util.Arrays;

public class HasTableColumnFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        QuickDAOConfig quickDAOConfig = (QuickDAOConfig) flowContext.checkData("quickDAOConfig");
        DatabaseType databaseType = (DatabaseType) flowContext.checkData("databaseType");
        String tableName = (String) flowContext.getData("tableName");
        String columnName = (String) flowContext.checkData("columnName");
        if(null==tableName){
            Class clazz = (Class) flowContext.checkData("clazz");
            Entity entity = quickDAOConfig.getEntityByClassName(clazz.getName());
            tableName = entity.tableName;
            columnName = entity.getColumnNameByFieldName(columnName);
        }

        flowContext.putTemporaryData("name", "判断表指定列是否存在");
        switch (databaseType){
            case H2:{
                tableName = tableName.toUpperCase();
                columnName = columnName.toUpperCase();
                flowContext.putTemporaryData("sql", "select table_name, column_name from information_schema.`columns` where table_schema = 'PUBLIC' and table_name = ? and column_name = ?;");
            }break;
            case SQLite:{
                columnName = "%"+columnName+"%";
                flowContext.putTemporaryData("sql", "select name from sqlite_master where name = ? and sql like ?");
            }break;
            case Mysql:
            case MariaDB:{
                flowContext.putTemporaryData("sql", "select table_name, column_name from information_schema.`columns` where table_schema = '" + quickDAOConfig.databaseContext.databaseName + "' and table_name = ? and column_name = ?;");
            }break;
            case Postgresql:{
                flowContext.putTemporaryData("sql", "select pg_class.relname as table_name, attname as column_name from pg_attribute join pg_class on pg_attribute.attrelid = pg_class.oid where attnum > 0 and atttypid > 0 and pg_class.relname = ? and attname = ?;");
            }break;
            case SQLServer:{
                flowContext.putTemporaryData("sql", "select table_name, column_name from information_schema.columns where table_name = ? and column_name = ?;");
            }break;
            case Oracle:{
                flowContext.putTemporaryData("sql", "select table_name, column_name from user_tab_columns where table_name = ? and column_name = ?");
            }break;
        }
        flowContext.putTemporaryData("parameters", Arrays.asList(tableName, columnName));
        flowContext.executeFlowList(new SetHasResultSetFlow(), new ExecuteQueryConnectionFlow());
    }

    @Override
    public String name() {
        return "表指定列是否存在";
    }
}
