package cn.schoolwow.quickdao.flow.ddl.createTable;

import cn.schoolwow.quickdao.domain.internal.DatabaseType;
import cn.schoolwow.quickdao.flow.ddl.createTable.common.ExecuteCreateTableFlow;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;

public class CreateTableFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        DatabaseType databaseType = (DatabaseType) flowContext.checkData("databaseType");
        switch (databaseType){
            case SQLite:{
                flowContext.executeFlowList(new SQLiteCreateTableFlow());
            }break;
            case H2:
            case Mysql:
            case MariaDB:{
                flowContext.executeFlowList(new MysqlCreateTableFlow());
            }break;
            case Postgresql:{
                flowContext.executeFlowList(new PostgresCreateTableFlow());
            }break;
            case SQLServer:{
                flowContext.executeFlowList(new SQLServerCreateTableFlow());
            }break;
            case Oracle:{
                flowContext.executeFlowList(new OracleCreateTableFlow());
            }break;
        }
        flowContext.executeFlowList(new ExecuteCreateTableFlow());
    }

    @Override
    public String name() {
        return "创建数据库表";
    }

}
