package cn.schoolwow.quickdao.flow.dcl;

import cn.schoolwow.quickdao.domain.external.dcl.GrantOption;
import cn.schoolwow.quickdao.domain.internal.DatabaseType;
import cn.schoolwow.quickdao.flow.executor.ExecuteUpdateConnectionFlow;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;

public class RevokeFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        DatabaseType databaseType = (DatabaseType) flowContext.checkData("databaseType");
        GrantOption grantOption = (GrantOption) flowContext.useData("grantOption");

        flowContext.putTemporaryData("name", "收回数据库权限");
        switch (databaseType){
            case Mysql:{
                flowContext.putTemporaryData("sql", "revoke " + grantOption.privileges + " on " + grantOption.databaseName + ".* from '" + grantOption.dataBaseUser.username + "'@'" + grantOption.dataBaseUser.host + "';");
            };break;
            case Postgresql:{
                flowContext.putTemporaryData("sql", "revoke " + grantOption.privileges + " on database " + grantOption.databaseName + " from " + grantOption.dataBaseUser.username + ";");
            };break;
            default:{
                throw new UnsupportedOperationException("当前数据库不支持收回数据库权限!数据库类型:"+databaseType.name());
            }
        }
        flowContext.executeFlowList(new ExecuteUpdateConnectionFlow());
    }

    @Override
    public String name() {
        return "收回数据库权限";
    }
}
