package cn.schoolwow.quickdao.flow.dcl;

import cn.schoolwow.quickdao.domain.external.dcl.GrantOption;
import cn.schoolwow.quickdao.domain.internal.DatabaseType;
import cn.schoolwow.quickdao.flow.executor.ExecuteUpdateConnectionFlow;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;

public class CreateUserAndGrantFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        DatabaseType databaseType = (DatabaseType) flowContext.checkData("databaseType");
        GrantOption grantOption = (GrantOption) flowContext.useData("grantOption");

        flowContext.putTemporaryData("name", "创建用户并授权");
        switch (databaseType){
            case Mysql:{
                flowContext.startFlow(new ExecuteUpdateConnectionFlow())
                        .putTemporaryData("sql", "grant " + grantOption.privileges + " on " + grantOption.databaseName + ".* to '" + grantOption.dataBaseUser.username + "'@'" + grantOption.dataBaseUser.host + "' identified by '" + grantOption.dataBaseUser.password + "';")
                        .execute();
            };break;
            case Postgresql:{
                flowContext.startFlow("postgre数据库创建用户并授权")
                        .next(new CreateUserFlow())
                        .next(new GrantFlow())
                        .next(new FlushPrivilegesFlow())
                        .execute();
            };break;
            default:{
                throw new UnsupportedOperationException("当前数据库不支持创建用户并授权!数据库类型:"+databaseType.name());
            }
        }
    }

    @Override
    public String name() {
        return "创建用户并授权";
    }
}
