package cn.schoolwow.quickdao.domain.internal.dql.query;

import cn.schoolwow.quickdao.dao.dql.condition.Condition;
import cn.schoolwow.quickdao.dao.dql.condition.ConditionImpl;
import cn.schoolwow.quickdao.domain.external.QuickDAOConfig;
import cn.schoolwow.quickdao.domain.internal.dql.subquery.SubQueryOption;
import cn.schoolwow.quickflow.QuickFlow;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class QueryOption implements Serializable {
    /**
     * 查询列信息
     * */
    public QueryColumnOption queryColumnOption = new QueryColumnOption();

    /**
     * 查询表信息
     * */
    public QueryTableOption queryTableOption = new QueryTableOption();

    /**
     * SQL片段信息
     * */
    public QueryFragmentOption queryFragmentOption = new QueryFragmentOption();

    /**
     * 分页信息
     * */
    public QueryPagingOption queryPagingOption = new QueryPagingOption();

    /**
     * 更新操作信息
     * */
    public QueryUpdateOption queryUpdateOption = new QueryUpdateOption();

    /**
     * 关联表
     * */
    public List<SubQueryOption> subQueryOptionList = new ArrayList<>();

    public transient QuickFlow quickFlow;

    public transient QuickDAOConfig quickDAOConfig;

    public void setConditionTableAliasName(Condition condition){
        ConditionImpl conditionImpl = (ConditionImpl) condition;
        if (null==conditionImpl.queryOption.queryTableOption.tableAliasName) {
            conditionImpl.queryOption.queryTableOption.tableAliasName = "t" + queryTableOption.joinTableIndex++;
        }
    }

}
