package cn.schoolwow.quickdao.domain.internal.dql.common;

import cn.schoolwow.quickdao.domain.internal.dql.query.QueryOption;
import cn.schoolwow.quickdao.domain.internal.dql.response.ResponseOption;

import java.util.ArrayList;
import java.util.List;

/**
 * 查询请求上下文对象
 * */
public class QueryContext {
    /**
     * 查询列
     */
    public String select = null;

    /**
     * 查询列参数
     * */
    public List<Object> selectParameters = new ArrayList<>();

    /**
     * from子句
     */
    public String from = null;

    /**
     * from子句参数列表
     * */
    public List<Object> fromParameters = new ArrayList<>();

    /**
     * join子句
     */
    public String join = "";

    /**
     * joinTable参数列表
     * */
    public List<Object> joinParameters = new ArrayList<>();

    /**
     * 查询条件
     */
    public String noAliasNameWhere = "";

    /**
     * 查询条件
     */
    public String where = "";

    /**
     * where参数列表
     * */
    public List<Object> whereParameters = new ArrayList<>();

    /**
     * 分组查询
     */
    public String groupBy = "";

    /**
     * having查询
     */
    public String having = "";

    /**
     * having参数列表
     * */
    public List<Object> havingParameters = new ArrayList<>();

    /**
     * 排序
     */
    public String orderBy = "";

    /**
     * 分页
     */
    public String limit = "";
    /**
     * set语句
     * */
    public String set = null;

    /**
     * set参数列表
     * */
    public List<Object> setParameters = new ArrayList<>();

    /**
     * 关联查询条件
     * */
    public QueryOption queryOption;

    /**
     * 关联响应
     * */
    public ResponseOption responseOption = new ResponseOption();

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("select:"+select+"\r\n");
        builder.append("select参数列表:"+setParameters+"\r\n");
        builder.append("from:"+from+"\r\n");
        builder.append("from参数列表:"+fromParameters+"\r\n");
        if(!join.isEmpty()){
            builder.append("join:"+join+"\r\n");
            builder.append("join参数列表:"+joinParameters+"\r\n");
        }
        if(!where.isEmpty()){
            builder.append("where:"+where+"\r\n");
            builder.append("where参数列表:"+whereParameters+"\r\n");
        }
        if(!groupBy.isEmpty()){
            builder.append("groupBy:"+groupBy+"\r\n");
        }
        if(!having.isEmpty()){
            builder.append("having:"+having+"\r\n");
            builder.append("having参数列表:"+havingParameters+"\r\n");
        }
        if(!orderBy.isEmpty()){
            builder.append("orderBy:"+orderBy+"\r\n");
        }
        if(!limit.isEmpty()){
            builder.append("limit:"+limit+"\r\n");
        }
        if(null!=set){
            builder.append("set:"+set+"\r\n");
            builder.append("set参数列表:"+setParameters+"\r\n");
        }
        return builder.toString();
    }
}
