package cn.schoolwow.quickdao.domain.internal.config;

import cn.schoolwow.quickdao.domain.external.Entity;
import cn.schoolwow.quickdao.provider.DatabaseProvider;

import javax.sql.DataSource;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/**
 * 数据库上下文对象
 * */
public class DatabaseContext {
    /**
     * 数据源
     */
    public DataSource dataSource;

    /**
     * 数据库名
     */
    public String databaseName;

    /**
     * 扫描后的实体类信息
     */
    public Map<String, Entity> entityMap = new HashMap<>();

    /**
     * 数据库表信息缓存
     */
    public final Map<String, Entity> databaseTableCache = new ConcurrentHashMap<>();

    /**
     * SQL语句缓存
     */
    public final ConcurrentHashMap<String, String> statementCache = new ConcurrentHashMap();

    /**
     * 数据库提供者
     */
    public DatabaseProvider databaseProvider;
}
