package cn.schoolwow.quickdao.domain.external.entity;

import cn.schoolwow.quickdao.annotation.*;

import java.time.LocalDateTime;

@TableName("quickdao_database_upgrade")
@Comment("SQL升级语句")
@UniqueField(columns = "comment")
public class DatabaseUpgrade {
    @Id(strategy = IdStrategy.AutoIncrement)
    private long id;

    @Comment("升级注释(唯一)")
    @Index(indexType = IndexType.UNIQUE)
    @ColumnType("varchar(128)")
    private String comment;

    @Comment("升级SQL语句")
    @ColumnType("mediumtext")
    private String sql;

    @Comment("是否执行成功")
    private boolean success;

    @TableField(createdAt = true)
    private LocalDateTime createdAt;

    @TableField(updatedAt = true)
    private LocalDateTime updatedAt;

    public long getId() {
        return id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getComment() {
        return comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getSql() {
        return sql;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public boolean isSuccess() {
        return success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public LocalDateTime getCreatedAt() {
        return createdAt;
    }

    public void setCreatedAt(LocalDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public LocalDateTime getUpdatedAt() {
        return updatedAt;
    }

    public void setUpdatedAt(LocalDateTime updatedAt) {
        this.updatedAt = updatedAt;
    }
}
