package cn.schoolwow.quickdao.dao.transaction;

import cn.schoolwow.quickdao.exception.SQLRuntimeException;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Savepoint;

public class TransactionOperationImpl implements TransactionOperation{
    private Connection transactionConnection;

    public TransactionOperationImpl(Connection transactionConnection) {
        this.transactionConnection = transactionConnection;
    }

    @Override
    public Connection getTransactionConnection() {
        return transactionConnection;
    }

    @Override
    public void setTransactionIsolation(int transactionIsolation) {
        try {
            transactionConnection.setTransactionIsolation(transactionIsolation);
        } catch (SQLException e) {
            throw new SQLRuntimeException(e);
        }
    }

    @Override
    public Savepoint setSavePoint() {
        try {
            return transactionConnection.setSavepoint();
        } catch (SQLException e) {
            throw new SQLRuntimeException(e);
        }
    }

    @Override
    public Savepoint setSavePoint(String name) {
        try {
            return transactionConnection.setSavepoint(name);
        } catch (SQLException e) {
            throw new SQLRuntimeException(e);
        }
    }

    @Override
    public void rollback() {
        try {
            transactionConnection.rollback();
        } catch (SQLException e) {
            throw new SQLRuntimeException(e);
        }
    }

    @Override
    public void rollback(Savepoint savePoint) {
        try {
            transactionConnection.rollback(savePoint);
        } catch (SQLException e) {
            throw new SQLRuntimeException(e);
        }
    }

    @Override
    public void commit() {
        try {
            transactionConnection.commit();
        } catch (SQLException e) {
            throw new SQLRuntimeException(e);
        }
    }

    @Override
    public void close() {
        try {
            transactionConnection.close();
        } catch (SQLException e) {
            throw new SQLRuntimeException(e);
        }
    }
}
