package cn.schoolwow.quickdao.provider;

import cn.schoolwow.quickdao.domain.internal.DatabaseType;

import java.util.HashMap;
import java.util.Map;

public class SQLServerDatabaseProvider implements DatabaseProvider {
    private Map<String, String> fieldTypeMapping = new HashMap<>();
    {
        fieldTypeMapping.put("byte", "TINYINT");
        fieldTypeMapping.put("java.lang.Byte", "TINYINT");
        fieldTypeMapping.put("[B", "BINARY");
        fieldTypeMapping.put("boolean", "TINYINT");
        fieldTypeMapping.put("java.lang.Boolean", "TINYINT");
        fieldTypeMapping.put("char", "TINYINT");
        fieldTypeMapping.put("java.lang.Character", "TINYINT");
        fieldTypeMapping.put("short", "SMALLINT");
        fieldTypeMapping.put("java.lang.Short", "SMALLINT");
        fieldTypeMapping.put("int", "INT");
        fieldTypeMapping.put("java.lang.Integer", "INTEGER(11)");
        fieldTypeMapping.put("float", "REAL");
        fieldTypeMapping.put("java.lang.Float", "REAL");
        fieldTypeMapping.put("long", "BIGINT");
        fieldTypeMapping.put("java.lang.Long", "BIGINT");
        fieldTypeMapping.put("double", "FLOAT");
        fieldTypeMapping.put("java.lang.Double", "FLOAT");
        fieldTypeMapping.put("java.lang.String", "VARCHAR(255)");
        fieldTypeMapping.put("java.util.Date", "DATETIME");
        fieldTypeMapping.put("java.sql.Date", "DATE");
        fieldTypeMapping.put("java.sql.Time", "TIME");
        fieldTypeMapping.put("java.sql.Timestamp", "TIMESTAMP");
        fieldTypeMapping.put("java.time.LocalDate", "DATE");
        fieldTypeMapping.put("java.time.LocalDateTime", "DATETIME");
        fieldTypeMapping.put("java.sql.Array", "");
        fieldTypeMapping.put("java.math.BigDecimal", "DECIMAL");
        fieldTypeMapping.put("java.sql.Blob", "BINARY");
        fieldTypeMapping.put("java.sql.Clob", "TEXT");
        fieldTypeMapping.put("java.sql.NClob", "TEXT");
        fieldTypeMapping.put("java.sql.Ref", "");
        fieldTypeMapping.put("java.net.URL", "");
        fieldTypeMapping.put("java.sql.RowId", "");
        fieldTypeMapping.put("java.sql.SQLXML", "");
        fieldTypeMapping.put("java.io.InputStream", "TEXT");
        fieldTypeMapping.put("java.io.Reader", "TEXT");
    }

    @Override
    public String comment(String comment) {
        return "";
    }

    @Override
    public String escape(String value) {
        return "\"" + value + "\"";
    }

    @Override
    public boolean returnGeneratedKeys() {
        return true;
    }

    @Override
    public Map<String, String> getTypeFieldMapping() {
        return fieldTypeMapping;
    }

    @Override
    public String name() {
        return "sqlserver";
    }

    @Override
    public DatabaseType getDatabaseType() {
        return DatabaseType.SQLServer;
    }
}
