package cn.schoolwow.quickdao.provider;

import cn.schoolwow.quickdao.domain.internal.DatabaseType;

import java.util.HashMap;
import java.util.Map;

public class OracleDatabaseProvider implements DatabaseProvider {
    private Map<String, String> fieldTypeMapping = new HashMap<>();
    {
        fieldTypeMapping.put("byte", "");
        fieldTypeMapping.put("java.lang.Byte", "");
        fieldTypeMapping.put("[B", "");
        fieldTypeMapping.put("boolean", "");
        fieldTypeMapping.put("char", "CHAR");
        fieldTypeMapping.put("java.lang.Character", "CHAR");
        fieldTypeMapping.put("short", "INTEGER");
        fieldTypeMapping.put("java.lang.Short", "INTEGER");
        fieldTypeMapping.put("int", "INTEGER");
        fieldTypeMapping.put("java.lang.Integer", "INTEGER");
        fieldTypeMapping.put("float", "BINARY_FLOAT");
        fieldTypeMapping.put("java.lang.Float", "BINARY_FLOAT");
        fieldTypeMapping.put("long", "INTEGER");
        fieldTypeMapping.put("java.lang.Long", "INTEGER");
        fieldTypeMapping.put("double", "BINARY_DOUBLE");
        fieldTypeMapping.put("java.lang.Double", "BINARY_DOUBLE");
        fieldTypeMapping.put("java.lang.String", "VARCHAR2(255)");
        fieldTypeMapping.put("java.util.Date", "TIMESTAMP");
        fieldTypeMapping.put("java.sql.Date", "DATE");
        fieldTypeMapping.put("java.sql.Timestamp", "TIMESTAMP");
        fieldTypeMapping.put("java.time.LocalDate", "DATE");
        fieldTypeMapping.put("java.time.LocalDateTime", "TIMESTAMP");
        fieldTypeMapping.put("java.sql.Array", "");
        fieldTypeMapping.put("java.math.BigDecimal", "INTEGER");
        fieldTypeMapping.put("java.sql.Blob", "BLOB");
        fieldTypeMapping.put("java.sql.Clob", "CLOB");
        fieldTypeMapping.put("java.sql.NClob", "NCLOB");
        fieldTypeMapping.put("java.sql.Ref", "");
        fieldTypeMapping.put("java.net.URL", "");
        fieldTypeMapping.put("java.sql.RowId", "");
        fieldTypeMapping.put("java.sql.SQLXML", "");
        fieldTypeMapping.put("java.io.InputStream", "");
        fieldTypeMapping.put("java.io.Reader", "");
    }

    @Override
    public String comment(String comment) {
        return "";
    }

    @Override
    public String escape(String value) {
        return "\"" + value + "\"";
    }

    @Override
    public boolean returnGeneratedKeys() {
        return true;
    }

    @Override
    public Map<String, String> getTypeFieldMapping() {
        return fieldTypeMapping;
    }

    @Override
    public String name() {
        return "oracle";
    }

    @Override
    public DatabaseType getDatabaseType() {
        return DatabaseType.Oracle;
    }
}
