package cn.schoolwow.quickdao.provider;

import cn.schoolwow.quickdao.domain.internal.DatabaseType;

import java.util.Map;

/**
 * 数据库提供者
 */
public interface DatabaseProvider {
    /**
     * 返回注释语句
     */
    String comment(String comment);

    /**
     * 转义表,列等
     */
    String escape(String value);

    /**
     * 是否返回自增id
     */
    boolean returnGeneratedKeys();

    /**
     * 获取默认Java类型与数据库类型映射关系表
     */
    Map<String, String> getTypeFieldMapping();

    /**
     * 数据库类型名称
     */
    String name();

    /**
     * 数据库类型名称
     */
    DatabaseType getDatabaseType();

}
