package cn.schoolwow.quickdao.flow.executor.common;

import cn.schoolwow.quickdao.domain.external.Entity;
import cn.schoolwow.quickdao.domain.external.QuickDAOConfig;
import cn.schoolwow.quickdao.domain.internal.dml.ManipulationOption;
import cn.schoolwow.quickdao.flow.dml.instance.update.common.SetUpdateInstanceByUniqueKeyParameterFlow;
import cn.schoolwow.quickdao.flow.dml.instance.update.common.SetUpdateInstanceByUniqueKeyStatementFlow;
import cn.schoolwow.quickdao.flow.executor.ExecuteUpdateConnectionFlow;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;

public class UpdateLogFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        QuickDAOConfig quickDAOConfig = (QuickDAOConfig) flowContext.checkData("quickDAOConfig");
        Object instance = flowContext.checkData("instance");
        Entity entity = quickDAOConfig.databaseContext.entityMap.get(instance.getClass().getName());
        if(null==entity){
            throw new IllegalArgumentException("日志类信息获取失败!日志类名:"+instance.getClass().getName());
        }

        flowContext.startFlow(new SetUpdateInstanceByUniqueKeyStatementFlow())
                .next(new SetUpdateInstanceByUniqueKeyParameterFlow())
                .next(new ExecuteUpdateConnectionFlow())
                .putTemporaryData("name", "更新日志记录")
                .putTemporaryData("entity", entity)
                .putTemporaryData("manipulationOption", new ManipulationOption())
                .execute();
    }

    @Override
    public String name() {
        return "更新日志记录";
    }
}
