package cn.schoolwow.quickdao.flow.executor.common;

import cn.schoolwow.quickdao.domain.external.QuickDAOConfig;
import cn.schoolwow.quickdao.domain.external.entity.SqlLog;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class InsertSqlLogFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        setSqlLog(flowContext);
        insertSqlLog(flowContext);
    }

    @Override
    public String name() {
        return "插入SQL日志";
    }

    private void setSqlLog(FlowContext flowContext){
        String sql = (String) flowContext.checkData("sql");
        String formatSQL = (String) flowContext.checkData("formatSQL");
        Exception e = (Exception) flowContext.getData("exception");
        List parameters = (List) flowContext.getData("parameters");
        String name = (String) flowContext.checkData("name");
        long startTime = (long) flowContext.checkData("startTime");
        int sqlLogType = (int) flowContext.checkData("sqlLogType");
        Integer effect = (Integer) flowContext.getData("effect");

        long endTime = System.currentTimeMillis();
        long consumeTime = endTime-startTime;

        SqlLog sqlLog = new SqlLog();
        sqlLog.setType(sqlLogType);
        sqlLog.setName(name);
        sqlLog.setConsumeTime(consumeTime);
        sqlLog.setStatement(sql);
        sqlLog.setFormatStatement(formatSQL);
        if(null!=parameters&&!parameters.isEmpty()){
            sqlLog.setParameters(parameters.toString());
        }
        sqlLog.setEffect(effect);
        if(null!=e){
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            sqlLog.setException(sw.toString());
        }
        flowContext.putData("sqlLog", sqlLog);
    }

    private void insertSqlLog(FlowContext flowContext) throws InterruptedException {
        Boolean insertSqlLog = (Boolean) flowContext.getData("insertSqlLog");
        if(null!=insertSqlLog&&!insertSqlLog){
            return;
        }

        QuickDAOConfig quickDAOConfig = (QuickDAOConfig) flowContext.checkData("quickDAOConfig");
        SqlLog sqlLog = (SqlLog) flowContext.checkData("sqlLog");
        if(quickDAOConfig.logRecordOption.recordSqlLog){
            quickDAOConfig.logRecordOption.sqlLogBlockingQueue.offer(sqlLog, 3, TimeUnit.SECONDS);
        }
    }
}
